/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.background.task.service.BackgroundTaskService;
import com.liferay.portal.background.task.service.persistence.BackgroundTaskFinder;
import com.liferay.portal.background.task.service.persistence.BackgroundTaskPersistence;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import java.sql.Connection;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class BackgroundTaskServiceBaseImpl
extends BaseServiceImpl
implements AopService,
BackgroundTaskService,
IdentifiableOSGiService {
    @Reference
    protected BackgroundTaskLocalService backgroundTaskLocalService;
    protected BackgroundTaskService backgroundTaskService;
    @Reference
    protected BackgroundTaskPersistence backgroundTaskPersistence;
    @Reference
    protected BackgroundTaskFinder backgroundTaskFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskServiceBaseImpl.class);

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BackgroundTaskService.class, IdentifiableOSGiService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.backgroundTaskService = (BackgroundTaskService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return BackgroundTaskService.class.getName();
    }

    protected Class<?> getModelClass() {
        return BackgroundTask.class;
    }

    protected String getModelClassName() {
        return BackgroundTask.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.backgroundTaskPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

