/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.internal.BackgroundTaskImpl;
import com.liferay.portal.background.task.internal.lock.helper.BackgroundTaskLockHelper;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

public class BackgroundTaskStatusMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskStatusMessageListener.class);
    private final BackgroundTaskLocalService _backgroundTaskLocalService;
    private final BackgroundTaskLockHelper _backgroundTaskLockHelper;
    private final BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;
    private final RoleLocalService _roleLocalService;
    private final UserLocalService _userLocalService;
    private final UserNotificationEventLocalService _userNotificationEventLocalService;

    public BackgroundTaskStatusMessageListener(BackgroundTaskLocalService backgroundTaskLocalService, BackgroundTaskStatusRegistry backgroundTaskStatusRegistry, LockManager lockManager, RoleLocalService roleLocalService, UserLocalService userLocalService, UserNotificationEventLocalService userNotificationEventLocalService) {
        this._backgroundTaskLocalService = backgroundTaskLocalService;
        this._backgroundTaskStatusRegistry = backgroundTaskStatusRegistry;
        this._backgroundTaskLockHelper = new BackgroundTaskLockHelper(lockManager);
        this._roleLocalService = roleLocalService;
        this._userLocalService = userLocalService;
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }

    protected void doReceive(Message message) throws Exception {
        this._translateBackgroundTaskStatusMessage(message);
        int status = message.getInteger("status");
        if (status == 5) {
            this._executeBackgroundTasks(message);
        } else if (status == 2) {
            this._executeBackgroundTasks(message);
            this._sendUserNotificationEvents(message);
        } else if (status == 4) {
            long backgroundTaskId = message.getLong("backgroundTaskId");
            if (!this._backgroundTaskLockHelper.isLockedBackgroundTask(new BackgroundTaskImpl(this._backgroundTaskLocalService.fetchBackgroundTask(backgroundTaskId)))) {
                this._executeBackgroundTasks(message);
            }
        } else if (status == 3) {
            this._executeBackgroundTasks(message);
            this._deleteBackgroundTask(message);
        }
    }

    private void _deleteBackgroundTask(Message message) throws Exception {
        long backgroundTaskId = message.getLong("backgroundTaskId");
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(backgroundTaskId);
        if (backgroundTask == null) {
            return;
        }
        Map taskContextMap = backgroundTask.getTaskContextMap();
        boolean deleteOnSuccess = GetterUtil.getBoolean(taskContextMap.get("deleteOnSuccess"));
        if (!deleteOnSuccess) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deleting background task " + backgroundTask.toString()));
        }
        this._backgroundTaskLocalService.deleteBackgroundTask(backgroundTaskId);
    }

    private void _executeBackgroundTasks(Message message) {
        BackgroundTask backgroundTask;
        String taskExecutorClassName = message.getString("taskExecutorClassName");
        if (Validator.isNull((String)taskExecutorClassName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Message " + String.valueOf(message) + " is missing the key \"taskExecutorClassName\""));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Acquiring next queued background task for " + taskExecutorClassName));
        }
        if ((backgroundTask = this._backgroundTaskLocalService.fetchFirstBackgroundTask(taskExecutorClassName, 4)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No additional queued background tasks for " + taskExecutorClassName));
            }
            return;
        }
        this._backgroundTaskLocalService.resumeBackgroundTask(backgroundTask.getBackgroundTaskId());
    }

    private void _sendUserNotificationEvents(Message message) throws Exception {
        long backgroundTaskId = message.getLong("backgroundTaskId");
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(backgroundTaskId);
        User user = this._userLocalService.fetchUser(backgroundTask.getUserId());
        long[] userIds = null;
        if (user != null && !user.isGuestUser()) {
            userIds = new long[]{user.getUserId()};
        } else {
            Role role = this._roleLocalService.fetchRole(backgroundTask.getCompanyId(), "Administrator");
            userIds = this._userLocalService.getRoleUserIds(role.getRoleId());
        }
        for (long userId : userIds) {
            if (!UserNotificationManagerUtil.isDeliver((long)userId, (String)"com_liferay_portal_background_task_web_internal_portlet_BackgroundTaskPortlet", (long)0L, (int)2, (int)10002)) continue;
            this._userNotificationEventLocalService.sendUserNotificationEvents(userId, "com_liferay_portal_background_task_web_internal_portlet_BackgroundTaskPortlet", 10002, false, JSONUtil.put((String)"name", (Object)backgroundTask.getName()).put("taskExecutorClassName", backgroundTask.getTaskExecutorClassName()));
        }
    }

    private void _translateBackgroundTaskStatusMessage(Message message) {
        long backgroundTaskId = message.getLong("backgroundTaskId");
        BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatusRegistry.getBackgroundTaskStatus(backgroundTaskId);
        if (backgroundTaskStatus == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to locate status for background task ", backgroundTaskId, " to process ", message}));
            }
            return;
        }
        BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator = this._backgroundTaskStatusRegistry.getBackgroundTaskStatusMessageTranslator(backgroundTaskId);
        if (backgroundTaskStatusMessageTranslator != null) {
            backgroundTaskStatusMessageTranslator.translate(backgroundTaskStatus, message);
        }
    }
}

