/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.background.task.internal.StaleBackgroundTaskException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.backgroundtask.DelegatingBackgroundTaskExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import java.util.Map;

public class ThreadLocalAwareBackgroundTaskExecutor
extends DelegatingBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(ThreadLocalAwareBackgroundTaskExecutor.class);
    private final BackgroundTaskThreadLocalManager _backgroundTaskThreadLocalManager;

    public ThreadLocalAwareBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, BackgroundTaskThreadLocalManager backgroundTaskThreadLocalManager) {
        super(backgroundTaskExecutor);
        this._backgroundTaskThreadLocalManager = backgroundTaskThreadLocalManager;
    }

    public BackgroundTaskExecutor clone() {
        return new ThreadLocalAwareBackgroundTaskExecutor(this.getBackgroundTaskExecutor(), this._backgroundTaskThreadLocalManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        long companyId = CompanyThreadLocal.getCompanyId();
        Map threadLocalValues = this._backgroundTaskThreadLocalManager.getThreadLocalValues();
        try {
            try {
                this._backgroundTaskThreadLocalManager.deserializeThreadLocals(backgroundTask.getCompanyId(), backgroundTask.getTaskContextMap());
            }
            catch (StaleBackgroundTaskException staleBackgroundTaskException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skipped stale background task " + String.valueOf(backgroundTask)), (Throwable)staleBackgroundTaskException);
                }
                BackgroundTaskResult backgroundTaskResult = BackgroundTaskResult.SUCCESS;
                this._backgroundTaskThreadLocalManager.setThreadLocalValues(companyId, threadLocalValues);
                return backgroundTaskResult;
            }
            BackgroundTaskResult backgroundTaskResult = super.execute(backgroundTask);
            return backgroundTaskResult;
        }
        finally {
            this._backgroundTaskThreadLocalManager.setThreadLocalValues(companyId, threadLocalValues);
        }
    }
}

