/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.scheduler;

import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.background.task.internal.configuration.BackgroundTaskCleanerConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.background.task.internal.configuration.BackgroundTaskCleanerConfiguration"}, service={SchedulerJobConfiguration.class})
public class BackgroundTaskCleanerSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    private volatile TriggerConfiguration _triggerConfiguration;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            if (!this._clusterMasterExecutor.isEnabled() || this._clusterMasterExecutor.isMaster()) {
                this._backgroundTaskManager.cleanUpBackgroundTasks();
            }
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        BackgroundTaskCleanerConfiguration backgroundTaskCleanerConfiguration = (BackgroundTaskCleanerConfiguration)ConfigurableUtil.createConfigurable(BackgroundTaskCleanerConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)backgroundTaskCleanerConfiguration.interval(), (TimeUnit)TimeUnit.MINUTE);
    }
}

