/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistry;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={BackgroundTaskExecutorRegistry.class})
public class BackgroundTaskExecutorRegistryImpl
implements BackgroundTaskExecutorRegistry {
    private BundleContext _bundleContext;
    private final Map<String, ServiceRegistration<BackgroundTaskExecutor>> _serviceRegistrations = new HashMap<String, ServiceRegistration<BackgroundTaskExecutor>>();
    private ServiceTrackerMap<String, BackgroundTaskExecutor> _serviceTrackerMap;

    public BackgroundTaskExecutor getBackgroundTaskExecutor(String backgroundTaskExecutorClassName) {
        return (BackgroundTaskExecutor)this._serviceTrackerMap.getService((Object)backgroundTaskExecutorClassName);
    }

    public synchronized void registerBackgroundTaskExecutor(String backgroundTaskExecutorClassName, BackgroundTaskExecutor backgroundTaskExecutor) {
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(BackgroundTaskExecutor.class, (Object)backgroundTaskExecutor, (Dictionary)HashMapDictionaryBuilder.put((Object)"background.task.executor.class.name", (Object)backgroundTaskExecutorClassName).build());
        this._serviceRegistrations.put(backgroundTaskExecutorClassName, (ServiceRegistration<BackgroundTaskExecutor>)serviceRegistration);
    }

    public synchronized void unregisterBackgroundTaskExecutor(String backgroundTaskExecutorClassName) {
        if (!this._serviceRegistrations.containsKey(backgroundTaskExecutorClassName)) {
            return;
        }
        ServiceRegistration<BackgroundTaskExecutor> serviceRegistration = this._serviceRegistrations.get(backgroundTaskExecutorClassName);
        serviceRegistration.unregister();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, BackgroundTaskExecutor.class, (String)"background.task.executor.class.name");
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._serviceTrackerMap.close();
        this._bundleContext = null;
        for (ServiceRegistration<BackgroundTaskExecutor> serviceRegistration : this._serviceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
    }
}

