/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.background.task.internal.upgrade.registry;

import com.liferay.portal.background.task.internal.upgrade.v1_0_0.SchemaUpgradeProcess;
import com.liferay.portal.background.task.internal.upgrade.v1_0_0.UpgradeKernelPackage;
import com.liferay.portal.background.task.internal.upgrade.v2_0_0.util.BackgroundTaskTable;
import com.liferay.portal.kernel.upgrade.BaseSQLServerDatetimeUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;

/**
 * @author Cristina Rodríguez
 */
@Component(service = UpgradeStepRegistrator.class)
public class BackgroundTaskServiceUpgradeStepRegistrator
	implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.register(
			"0.0.1", "0.0.2", new SchemaUpgradeProcess(),
			new UpgradeKernelPackage());

		registry.register(
			"0.0.2", "1.0.0",
			UpgradeProcessFactory.alterColumnType(
				"BackgroundTask", "name", "VARCHAR(255) null"),
			UpgradeProcessFactory.alterColumnName(
				"BackgroundTask", "taskContext", "taskContextMap TEXT null"));

		registry.register(
			"1.0.0", "2.0.0",
			new BaseSQLServerDatetimeUpgradeProcess(
				new Class<?>[] {BackgroundTaskTable.class}));
	}

}