/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.messaging;

import com.liferay.portal.background.task.internal.BackgroundTaskImpl;
import com.liferay.portal.background.task.internal.lock.helper.BackgroundTaskLockHelper;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.Validator;

public class BackgroundTaskQueuingMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskQueuingMessageListener.class);
    private final BackgroundTaskLocalService _backgroundTaskLocalService;
    private final BackgroundTaskLockHelper _backgroundTaskLockHelper;

    public BackgroundTaskQueuingMessageListener(BackgroundTaskLocalService backgroundTaskLocalService, LockManager lockManager) {
        this._backgroundTaskLocalService = backgroundTaskLocalService;
        this._backgroundTaskLockHelper = new BackgroundTaskLockHelper(lockManager);
    }

    protected void doReceive(Message message) throws Exception {
        long backgroundTaskId;
        String taskExecutorClassName = (String)message.get("taskExecutorClassName");
        if (Validator.isNull((String)taskExecutorClassName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Message " + message + " is missing the key \"taskExecutorClassName\""));
            }
            return;
        }
        int status = (Integer)message.get("status");
        if (status == 5 || status == 2 || status == 3) {
            this._executeQueuedBackgroundTasks(taskExecutorClassName);
        } else if (status == 4 && !this._backgroundTaskLockHelper.isLockedBackgroundTask(new BackgroundTaskImpl(this._backgroundTaskLocalService.fetchBackgroundTask(backgroundTaskId = ((Long)message.get("backgroundTaskId")).longValue())))) {
            this._executeQueuedBackgroundTasks(taskExecutorClassName);
        }
    }

    private void _executeQueuedBackgroundTasks(String taskExecutorClassName) {
        BackgroundTask backgroundTask;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Acquiring next queued background task for " + taskExecutorClassName));
        }
        if ((backgroundTask = this._backgroundTaskLocalService.fetchFirstBackgroundTask(taskExecutorClassName, 4)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No additional queued background tasks for " + taskExecutorClassName));
            }
            return;
        }
        this._backgroundTaskLocalService.resumeBackgroundTask(backgroundTask.getBackgroundTaskId());
    }
}

