/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BackgroundTaskStatusRegistry.class})
public class BackgroundTaskStatusRegistryImpl
implements BackgroundTaskStatusRegistry {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskStatusRegistryImpl.class);
    private final Map<Long, BackgroundTaskStatus> _backgroundTaskStatuses = new HashMap<Long, BackgroundTaskStatus>();
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskStatus getBackgroundTaskStatus(long backgroundTaskId) {
        if (!this._clusterMasterExecutor.isMaster()) {
            return this._getMasterBackgroundTaskStatus(backgroundTaskId);
        }
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatuses.get(backgroundTaskId);
            return backgroundTaskStatus;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskStatus registerBackgroundTaskStatus(long backgroundTaskId) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatuses.get(backgroundTaskId);
            if (backgroundTaskStatus == null) {
                backgroundTaskStatus = new BackgroundTaskStatus();
                this._backgroundTaskStatuses.put(backgroundTaskId, backgroundTaskStatus);
            }
            BackgroundTaskStatus backgroundTaskStatus2 = backgroundTaskStatus;
            return backgroundTaskStatus2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskStatus unregisterBackgroundTaskStatus(long backgroundTaskId) {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatuses.remove(backgroundTaskId);
            return backgroundTaskStatus;
        }
        finally {
            lock.unlock();
        }
    }

    private BackgroundTaskStatus _getMasterBackgroundTaskStatus(long backgroundTaskId) {
        try {
            MethodHandler methodHandler = new MethodHandler(BackgroundTaskStatusRegistryUtil.class.getDeclaredMethod("getBackgroundTaskStatus", Long.TYPE), new Object[]{backgroundTaskId});
            NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(methodHandler);
            return (BackgroundTaskStatus)future.get();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to retrieve status from master node", (Throwable)exception);
            return null;
        }
    }
}

