/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.background.task.service.http;

import com.liferay.portal.background.task.service.BackgroundTaskServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;

/**
 * Provides the HTTP utility for the
 * <code>BackgroundTaskServiceUtil</code> service
 * utility. The
 * static methods of this class calls the same methods of the service utility.
 * However, the signatures are different because it requires an additional
 * <code>HttpPrincipal</code> parameter.
 *
 * <p>
 * The benefits of using the HTTP utility is that it is fast and allows for
 * tunneling without the cost of serializing to text. The drawback is that it
 * only works with Java.
 * </p>
 *
 * <p>
 * Set the property <b>tunnel.servlet.hosts.allowed</b> in portal.properties to
 * configure security.
 * </p>
 *
 * <p>
 * The HTTP utility is only generated for remote services.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public class BackgroundTaskServiceHttp {

	public static int getBackgroundTasksCount(
		HttpPrincipal httpPrincipal, long groupId, String taskExecutorClassName,
		boolean completed) {

		try {
			MethodKey methodKey = new MethodKey(
				BackgroundTaskServiceUtil.class, "getBackgroundTasksCount",
				_getBackgroundTasksCountParameterTypes0);

			MethodHandler methodHandler = new MethodHandler(
				methodKey, groupId, taskExecutorClassName, completed);

			Object returnObj = null;

			try {
				returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
			}
			catch (Exception exception) {
				throw new com.liferay.portal.kernel.exception.SystemException(
					exception);
			}

			return ((Integer)returnObj).intValue();
		}
		catch (com.liferay.portal.kernel.exception.SystemException
					systemException) {

			_log.error(systemException, systemException);

			throw systemException;
		}
	}

	public static int getBackgroundTasksCount(
		HttpPrincipal httpPrincipal, long groupId, String name,
		String taskExecutorClassName) {

		try {
			MethodKey methodKey = new MethodKey(
				BackgroundTaskServiceUtil.class, "getBackgroundTasksCount",
				_getBackgroundTasksCountParameterTypes1);

			MethodHandler methodHandler = new MethodHandler(
				methodKey, groupId, name, taskExecutorClassName);

			Object returnObj = null;

			try {
				returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
			}
			catch (Exception exception) {
				throw new com.liferay.portal.kernel.exception.SystemException(
					exception);
			}

			return ((Integer)returnObj).intValue();
		}
		catch (com.liferay.portal.kernel.exception.SystemException
					systemException) {

			_log.error(systemException, systemException);

			throw systemException;
		}
	}

	public static String getBackgroundTaskStatusJSON(
		HttpPrincipal httpPrincipal, long backgroundTaskId) {

		try {
			MethodKey methodKey = new MethodKey(
				BackgroundTaskServiceUtil.class, "getBackgroundTaskStatusJSON",
				_getBackgroundTaskStatusJSONParameterTypes2);

			MethodHandler methodHandler = new MethodHandler(
				methodKey, backgroundTaskId);

			Object returnObj = null;

			try {
				returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
			}
			catch (Exception exception) {
				throw new com.liferay.portal.kernel.exception.SystemException(
					exception);
			}

			return (String)returnObj;
		}
		catch (com.liferay.portal.kernel.exception.SystemException
					systemException) {

			_log.error(systemException, systemException);

			throw systemException;
		}
	}

	private static Log _log = LogFactoryUtil.getLog(
		BackgroundTaskServiceHttp.class);

	private static final Class<?>[] _getBackgroundTasksCountParameterTypes0 =
		new Class[] {long.class, String.class, boolean.class};
	private static final Class<?>[] _getBackgroundTasksCountParameterTypes1 =
		new Class[] {long.class, String.class, String.class};
	private static final Class<?>[]
		_getBackgroundTaskStatusJSONParameterTypes2 = new Class[] {long.class};

}