/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.internal.BackgroundTaskImpl;
import com.liferay.portal.background.task.internal.lock.BackgroundTaskLockHelper;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.base.BackgroundTaskLocalServiceBaseImpl;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.background.task.model.BackgroundTask"}, service={AopService.class})
public class BackgroundTaskLocalServiceImpl
extends BackgroundTaskLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskLocalServiceImpl.class);
    private BackgroundTaskLockHelper _backgroundTaskLockHelper;
    @Reference
    private BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;
    @Reference
    private BackgroundTaskThreadLocalManager _backgroundTaskThreadLocalManager;
    @Reference
    private LockManager _lockManager;
    @Reference
    private MessageBus _messageBus;

    @Override
    public BackgroundTask addBackgroundTask(BackgroundTask backgroundTask) {
        HashMap taskContextMap = backgroundTask.getTaskContextMap();
        if (taskContextMap == null) {
            taskContextMap = new HashMap();
            backgroundTask.setTaskContextMap(taskContextMap);
        }
        this._backgroundTaskThreadLocalManager.serializeThreadLocals(taskContextMap);
        backgroundTask = super.addBackgroundTask(backgroundTask);
        final long backgroundTaskId = backgroundTask.getBackgroundTaskId();
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BackgroundTaskLocalServiceImpl.this.backgroundTaskLocalService.triggerBackgroundTask(backgroundTaskId);
                return null;
            }
        });
        return backgroundTask;
    }

    public BackgroundTask addBackgroundTask(long userId, long groupId, String name, String taskExecutorClassName, Map<String, Serializable> taskContextMap, ServiceContext serviceContext) throws PortalException {
        return this.addBackgroundTask(userId, groupId, name, null, taskExecutorClassName, taskContextMap, serviceContext);
    }

    public BackgroundTask addBackgroundTask(long userId, long groupId, String name, String[] servletContextNames, Class<?> taskExecutorClass, Map<String, Serializable> taskContextMap, ServiceContext serviceContext) throws PortalException {
        return this.addBackgroundTask(userId, groupId, name, servletContextNames, taskExecutorClass.getName(), taskContextMap, serviceContext);
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, File file) throws PortalException {
        BackgroundTask backgroundTask = this.getBackgroundTask(backgroundTaskId);
        Folder folder = backgroundTask.addAttachmentsFolder();
        PortletFileRepositoryUtil.addPortletFileEntry((long)backgroundTask.getGroupId(), (long)userId, (String)BackgroundTask.class.getName(), (long)backgroundTask.getPrimaryKey(), (String)"189", (long)folder.getFolderId(), (File)file, (String)fileName, (String)"application/zip", (boolean)false);
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, InputStream inputStream) throws PortalException {
        BackgroundTask backgroundTask = this.getBackgroundTask(backgroundTaskId);
        Folder folder = backgroundTask.addAttachmentsFolder();
        PortletFileRepositoryUtil.addPortletFileEntry((long)backgroundTask.getGroupId(), (long)userId, (String)BackgroundTask.class.getName(), (long)backgroundTask.getPrimaryKey(), (String)"189", (long)folder.getFolderId(), (InputStream)inputStream, (String)fileName, (String)"application/zip", (boolean)false);
    }

    public BackgroundTask amendBackgroundTask(long backgroundTaskId, Map<String, Serializable> taskContextMap, int status, ServiceContext serviceContext) {
        return this.amendBackgroundTask(backgroundTaskId, taskContextMap, status, null, serviceContext);
    }

    public BackgroundTask amendBackgroundTask(long backgroundTaskId, Map<String, Serializable> taskContextMap, int status, String statusMessage, ServiceContext serviceContext) {
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
        if (backgroundTask == null) {
            return null;
        }
        if (taskContextMap != null) {
            this._backgroundTaskThreadLocalManager.serializeThreadLocals(taskContextMap);
            backgroundTask.setTaskContextMap(taskContextMap);
        }
        if (status == 2 || status == 3) {
            backgroundTask.setCompleted(true);
            backgroundTask.setCompletionDate(new Date());
        }
        backgroundTask.setStatus(status);
        if (Validator.isNotNull((String)statusMessage)) {
            backgroundTask.setStatusMessage(statusMessage);
        }
        return (BackgroundTask)this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
    }

    @Clusterable(onMaster=true)
    public void cleanUpBackgroundTask(long backgroundTaskId, final int status) {
        BackgroundTask backgroundTask;
        block2: {
            backgroundTask = this.fetchBackgroundTask(backgroundTaskId);
            try {
                this._backgroundTaskLockHelper.unlockBackgroundTask(new BackgroundTaskImpl(backgroundTask));
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                message.put("name", (Object)backgroundTask.getName());
                message.put("status", (Object)status);
                message.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                BackgroundTaskLocalServiceImpl.this._messageBus.sendMessage("liferay/background_task_status", message);
                return null;
            }
        });
    }

    @Clusterable(onMaster=true)
    public void cleanUpBackgroundTasks() {
        List backgroundTasks = this.backgroundTaskPersistence.findByCompleted(false);
        for (BackgroundTask backgroundTask : backgroundTasks) {
            if (backgroundTask.getStatus() == 1) {
                backgroundTask.setCompleted(true);
                backgroundTask.setStatus(2);
                backgroundTask = (BackgroundTask)this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
            }
            this.cleanUpBackgroundTask(backgroundTask.getBackgroundTaskId(), backgroundTask.getStatus());
        }
    }

    @Override
    public BackgroundTask deleteBackgroundTask(BackgroundTask backgroundTask) throws PortalException {
        long folderId = backgroundTask.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
        }
        if (backgroundTask.getStatus() == 1) {
            this.cleanUpBackgroundTask(backgroundTask.getBackgroundTaskId(), 5);
        }
        return (BackgroundTask)this.backgroundTaskPersistence.remove((BaseModel)backgroundTask);
    }

    @Override
    public BackgroundTask deleteBackgroundTask(long backgroundTaskId) throws PortalException {
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.findByPrimaryKey(backgroundTaskId);
        return this.deleteBackgroundTask(backgroundTask);
    }

    public void deleteCompanyBackgroundTasks(long companyId) throws PortalException {
        List backgroundTasks = this.backgroundTaskPersistence.findByCompanyId(companyId);
        for (BackgroundTask backgroundTask : backgroundTasks) {
            this.deleteBackgroundTask(backgroundTask);
        }
    }

    public void deleteGroupBackgroundTasks(long groupId) throws PortalException {
        List backgroundTasks = this.backgroundTaskPersistence.findByGroupId(groupId);
        for (BackgroundTask backgroundTask : backgroundTasks) {
            this.deleteBackgroundTask(backgroundTask);
        }
    }

    public void deleteGroupBackgroundTasks(long groupId, String name, String taskExecutorClassName) throws PortalException {
        List backgroundTasks = this.backgroundTaskPersistence.findByG_N_T(groupId, name, taskExecutorClassName);
        for (BackgroundTask backgroundTask : backgroundTasks) {
            this.deleteBackgroundTask(backgroundTask);
        }
    }

    @Override
    public BackgroundTask fetchBackgroundTask(long backgroundTaskId) {
        return this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
    }

    public BackgroundTask fetchFirstBackgroundTask(long groupId, String taskExecutorClassName, boolean completed, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.fetchByG_T_C_First(groupId, taskExecutorClassName, completed, orderByComparator);
    }

    public BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status) {
        return this.fetchFirstBackgroundTask(taskExecutorClassName, status, null);
    }

    public BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.fetchByT_S_First(taskExecutorClassName, status, orderByComparator);
    }

    @Override
    public BackgroundTask getBackgroundTask(long backgroundTaskId) throws PortalException {
        return this.backgroundTaskPersistence.findByPrimaryKey(backgroundTaskId);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, int status) {
        return this.backgroundTaskPersistence.findByG_S(groupId, status);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName) {
        return this.backgroundTaskPersistence.findByG_T(groupId, taskExecutorClassName);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, boolean completed, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_T_C(groupId, taskExecutorClassName, completed, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, int status) {
        return this.backgroundTaskPersistence.findByG_T_S(groupId, taskExecutorClassName, status);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_T(groupId, taskExecutorClassName, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String name, String taskExecutorClassName, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_N_T(groupId, name, taskExecutorClassName, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String[] taskExecutorClassNames, int status) {
        return this.backgroundTaskPersistence.findByG_T_S(groupId, taskExecutorClassNames, status);
    }

    public List<BackgroundTask> getBackgroundTasks(long[] groupIds, String name, String taskExecutorClassName, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_N_T(groupIds, name, new String[]{taskExecutorClassName}, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long[] groupIds, String name, String[] taskExecutorClassNames, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_N_T(groupIds, name, taskExecutorClassNames, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long[] groupIds, String[] taskExecutorClassNames) {
        return this.backgroundTaskPersistence.findByG_T(groupIds, taskExecutorClassNames);
    }

    public List<BackgroundTask> getBackgroundTasks(long[] groupIds, String[] taskExecutorClassNames, boolean completed) {
        return this.backgroundTaskPersistence.findByG_T_C(groupIds, taskExecutorClassNames, completed);
    }

    public List<BackgroundTask> getBackgroundTasks(long[] groupIds, String[] taskExecutorClassNames, boolean completed, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_T_C(groupIds, taskExecutorClassNames, completed, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long[] groupIds, String[] taskExecutorClassNames, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_T(groupIds, taskExecutorClassNames, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassName, status);
    }

    public List<BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassName, status, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(String[] taskExecutorClassNames, int status) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassNames, status);
    }

    public List<BackgroundTask> getBackgroundTasks(String[] taskExecutorClassNames, int status, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassNames, status, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasksByDuration(long[] groupIds, String[] taskExecutorClassNames, boolean completed, int start, int end, boolean orderByType) {
        return this.backgroundTaskFinder.findByG_T_C(groupIds, taskExecutorClassNames, Boolean.valueOf(completed), start, end, orderByType);
    }

    public List<BackgroundTask> getBackgroundTasksByDuration(long[] groupIds, String[] taskExecutorClassNames, int start, int end, boolean orderByType) {
        return this.backgroundTaskFinder.findByG_T_C(groupIds, taskExecutorClassNames, null, start, end, orderByType);
    }

    public int getBackgroundTasksCount(long groupId, String taskExecutorClassName) {
        return this.backgroundTaskPersistence.countByG_T(groupId, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long groupId, String taskExecutorClassName, boolean completed) {
        return this.backgroundTaskPersistence.countByG_T_C(groupId, taskExecutorClassName, completed);
    }

    public int getBackgroundTasksCount(long groupId, String name, String taskExecutorClassName) {
        return this.backgroundTaskPersistence.countByG_N_T(groupId, name, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long groupId, String name, String taskExecutorClassName, boolean completed) {
        return this.backgroundTaskPersistence.countByG_N_T_C(groupId, name, taskExecutorClassName, completed);
    }

    public int getBackgroundTasksCount(long[] groupIds, String name, String taskExecutorClassName) {
        return this.backgroundTaskPersistence.countByG_N_T(groupIds, name, new String[]{taskExecutorClassName});
    }

    public int getBackgroundTasksCount(long[] groupIds, String name, String taskExecutorClassName, boolean completed) {
        return this.backgroundTaskPersistence.countByG_N_T_C(groupIds, name, taskExecutorClassName, completed);
    }

    public int getBackgroundTasksCount(long[] groupIds, String name, String[] taskExecutorClassName) {
        return this.backgroundTaskPersistence.countByG_N_T(groupIds, name, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long[] groupIds, String[] taskExecutorClassNames) {
        return this.backgroundTaskPersistence.countByG_T(groupIds, taskExecutorClassNames);
    }

    public int getBackgroundTasksCount(long[] groupIds, String[] taskExecutorClassNames, boolean completed) {
        return this.backgroundTaskPersistence.countByG_T_C(groupIds, taskExecutorClassNames, completed);
    }

    @Clusterable(onMaster=true)
    public String getBackgroundTaskStatusJSON(long backgroundTaskId) {
        BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatusRegistry.getBackgroundTaskStatus(backgroundTaskId);
        if (backgroundTaskStatus != null) {
            return backgroundTaskStatus.getAttributesJSON();
        }
        return "";
    }

    @Clusterable(onMaster=true)
    public void resumeBackgroundTask(long backgroundTaskId) {
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
        if (backgroundTask == null || backgroundTask.getStatus() != 4) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No background task found with queued status for background task ID " + backgroundTaskId));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Attempting to resume background task " + backgroundTaskId));
        }
        Message message = new Message();
        message.put("backgroundTaskId", (Object)backgroundTaskId);
        this._messageBus.sendMessage("liferay/background_task", message);
    }

    @Clusterable(onMaster=true)
    public void triggerBackgroundTask(long backgroundTaskId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Attempting to trigger background task " + backgroundTaskId));
        }
        Message message = new Message();
        message.put("backgroundTaskId", (Object)backgroundTaskId);
        this._messageBus.sendMessage("liferay/background_task", message);
    }

    @Activate
    protected void activate() {
        this._backgroundTaskLockHelper = new BackgroundTaskLockHelper(this._lockManager);
    }

    protected BackgroundTask addBackgroundTask(long userId, long groupId, String name, String[] servletContextNames, String taskExecutorClassName, Map<String, Serializable> taskContextMap, ServiceContext serviceContext) throws PortalException {
        User user = null;
        if (userId != 0L) {
            user = this.userLocalService.fetchUser(userId);
        }
        final long backgroundTaskId = this.counterLocalService.increment();
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.create(backgroundTaskId);
        if (user != null) {
            backgroundTask.setCompanyId(user.getCompanyId());
            backgroundTask.setUserName(user.getFullName());
        } else {
            backgroundTask.setCompanyId(0L);
            backgroundTask.setUserName("");
        }
        backgroundTask.setGroupId(groupId);
        backgroundTask.setUserId(userId);
        backgroundTask.setName(name);
        if (ArrayUtil.isNotEmpty((Object[])servletContextNames)) {
            backgroundTask.setServletContextNames(StringUtil.merge((Object[])servletContextNames));
        }
        backgroundTask.setTaskExecutorClassName(taskExecutorClassName);
        if (taskContextMap == null) {
            taskContextMap = new HashMap<String, Serializable>();
        }
        this._backgroundTaskThreadLocalManager.serializeThreadLocals(taskContextMap);
        backgroundTask.setTaskContextMap(taskContextMap);
        backgroundTask.setStatus(0);
        backgroundTask = (BackgroundTask)this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BackgroundTaskLocalServiceImpl.this.backgroundTaskLocalService.triggerBackgroundTask(backgroundTaskId);
                return null;
            }
        });
        return backgroundTask;
    }
}

