/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.model.impl.BackgroundTaskImpl;
import com.liferay.portal.background.task.service.persistence.BackgroundTaskFinder;
import com.liferay.portal.background.task.service.persistence.impl.BackgroundTaskFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BackgroundTaskFinder.class})
public class BackgroundTaskFinderImpl
extends BackgroundTaskFinderBaseImpl
implements BackgroundTaskFinder {
    public static final String FIND_BY_G_T_C = BackgroundTaskFinder.class.getName() + ".findByG_T_C";
    @Reference
    private CustomSQL _customSQL;

    public List<BackgroundTask> findByG_T_C(long[] groupIds, String[] taskExecutorClassNames, Boolean completed, int start, int end, boolean orderByType) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_T_C);
            sql = this._replaceWhereConditions(groupIds, taskExecutorClassNames, sql, completed);
            sql = StringUtil.replace((String)sql, (String)"[$ORDER_BY_TYPE$]", (String)(orderByType ? "ASC" : "DESC"));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("BackgroundTask", BackgroundTaskImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            for (long groupId : groupIds) {
                queryPos.add(groupId);
            }
            for (String taskExecutorClassName : taskExecutorClassNames) {
                queryPos.add(taskExecutorClassName);
            }
            if (completed != null) {
                queryPos.add(completed.booleanValue());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private String _getGroupCriteria(long[] groupIds) {
        String result = "";
        if (groupIds.length > 0) {
            StringBundler sb = new StringBundler(groupIds.length + 2);
            sb.append("(");
            for (int i = 0; i < groupIds.length; ++i) {
                sb.append("(BackgroundTask.groupId = ?) OR ");
            }
            sb.append(")");
            result = StringUtil.replaceLast((String)sb.toString(), (String)" OR ", (String)"");
        }
        return result;
    }

    private String _getTaskExecutorClassNameCriteria(String[] classNames) {
        String result = "";
        if (classNames.length > 0) {
            StringBundler sb = new StringBundler(classNames.length + 2);
            sb.append("(");
            for (int i = 0; i < classNames.length; ++i) {
                sb.append("(BackgroundTask.taskExecutorClassName = ?) OR ");
            }
            sb.append(")");
            result = StringUtil.replaceLast((String)sb.toString(), (String)" OR ", (String)"");
        }
        return result;
    }

    private String _replaceWhereConditions(long[] groupIds, String[] taskExecutorClassNames, String sql, Boolean completed) {
        StringBundler sb = new StringBundler(5);
        String groupCriteria = GetterUtil.getString((String)this._getGroupCriteria(groupIds));
        String taskExecutorCriteria = GetterUtil.getString((String)this._getTaskExecutorClassNameCriteria(taskExecutorClassNames));
        sb.append(groupCriteria);
        if (!groupCriteria.isEmpty() && !taskExecutorCriteria.isEmpty()) {
            sb.append(" AND ");
        }
        sb.append(taskExecutorCriteria);
        if (completed != null) {
            if (Validator.isNotNull((String)groupCriteria) && Validator.isNotNull((String)taskExecutorCriteria)) {
                sb.append(" AND ");
            }
            sb.append("(BackgroundTask.completed = ?)");
        }
        sql = Validator.isNotNull((String)sb.toString()) ? StringUtil.replace((String)sql, (String)"[$WHERE_CONDITIONS$]", (String)("WHERE " + sb.toString())) : StringUtil.removeSubstring((String)sql, (String)"[$WHERE_CONDITIONS$]");
        return sql;
    }
}

