/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.background.task.internal.StaleBackgroundTaskException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BackgroundTaskThreadLocalManager.class})
public class BackgroundTaskThreadLocalManagerImpl
implements BackgroundTaskThreadLocalManager {
    protected static final String KEY_THREAD_LOCAL_VALUES = "threadLocalValues";
    @Reference
    protected CompanyLocalService companyLocalService;
    private PermissionCheckerFactory _permissionCheckerFactory;
    private UserLocalService _userLocalService;

    public void deserializeThreadLocals(Map<String, Serializable> taskContextMap) {
        Map threadLocalValues = (Map)((Object)taskContextMap.get(KEY_THREAD_LOCAL_VALUES));
        this.setThreadLocalValues(threadLocalValues);
    }

    public Map<String, Serializable> getThreadLocalValues() {
        HashMap<String, Serializable> threadLocalValues = new HashMap<String, Serializable>();
        threadLocalValues.put("clusterInvoke", Boolean.valueOf(ClusterInvokeThreadLocal.isEnabled()));
        threadLocalValues.put("companyId", CompanyThreadLocal.getCompanyId());
        threadLocalValues.put("defaultLocale", LocaleThreadLocal.getDefaultLocale());
        threadLocalValues.put("groupId", GroupThreadLocal.getGroupId());
        threadLocalValues.put("principalName", (Serializable)((Object)PrincipalThreadLocal.getName()));
        threadLocalValues.put("siteDefaultLocale", LocaleThreadLocal.getSiteDefaultLocale());
        threadLocalValues.put("themeDisplayLocale", LocaleThreadLocal.getThemeDisplayLocale());
        return threadLocalValues;
    }

    public void serializeThreadLocals(Map<String, Serializable> taskContextMap) {
        HashMap<String, Serializable> taskContextThreadLocalValues = (HashMap<String, Serializable>)taskContextMap.get(KEY_THREAD_LOCAL_VALUES);
        if (taskContextThreadLocalValues == null) {
            taskContextThreadLocalValues = new HashMap<String, Serializable>();
            taskContextMap.put(KEY_THREAD_LOCAL_VALUES, taskContextThreadLocalValues);
        }
        Map<String, Serializable> currentThreadLocalValues = this.getThreadLocalValues();
        taskContextThreadLocalValues.putAll(currentThreadLocalValues);
    }

    public void setThreadLocalValues(Map<String, Serializable> threadLocalValues) {
        Locale themeDisplayLocale;
        Locale siteDefaultLocale;
        String principalName;
        long groupId;
        Locale defaultLocale;
        Boolean clusterInvoke;
        if (MapUtil.isEmpty(threadLocalValues)) {
            return;
        }
        long companyId = GetterUtil.getLong((Object)threadLocalValues.get("companyId"));
        if (companyId > 0L) {
            CompanyThreadLocal.setCompanyId((Long)this.requireCompany(companyId));
        }
        if ((clusterInvoke = (Boolean)threadLocalValues.get("clusterInvoke")) != null) {
            ClusterInvokeThreadLocal.setEnabled((boolean)clusterInvoke);
        }
        if ((defaultLocale = (Locale)threadLocalValues.get("defaultLocale")) != null) {
            LocaleThreadLocal.setDefaultLocale((Locale)defaultLocale);
        }
        if ((groupId = GetterUtil.getLong((Object)threadLocalValues.get("groupId"))) > 0L) {
            GroupThreadLocal.setGroupId((Long)groupId);
        }
        if (Validator.isNotNull((String)(principalName = GetterUtil.getString((Object)threadLocalValues.get("principalName"))))) {
            PrincipalThreadLocal.setName((String)principalName);
        }
        if (Validator.isNotNull((String)principalName)) {
            User user = this._userLocalService.fetchUser(PrincipalThreadLocal.getUserId());
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionCheckerFactory.create(user));
        }
        if ((siteDefaultLocale = (Locale)threadLocalValues.get("siteDefaultLocale")) != null) {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
        if ((themeDisplayLocale = (Locale)threadLocalValues.get("themeDisplayLocale")) != null) {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)themeDisplayLocale);
        }
    }

    protected long requireCompany(long companyId) {
        Company company = this.companyLocalService.fetchCompany(companyId);
        if (company != null) {
            return companyId;
        }
        throw new StaleBackgroundTaskException("Unable to find company " + companyId);
    }

    @Reference(unbind="-")
    protected void setPermissionCheckerFactory(PermissionCheckerFactory permissionCheckerFactory) {
        this._permissionCheckerFactory = permissionCheckerFactory;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

