/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.messaging;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.internal.SerialBackgroundTaskExecutor;
import com.liferay.portal.background.task.internal.ThreadLocalAwareBackgroundTaskExecutor;
import com.liferay.portal.background.task.internal.messaging.BackgroundTaskStatusMessageListener;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.backgroundtask.ClassLoaderAwareBackgroundTaskExecutor;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;

public class BackgroundTaskMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskMessageListener.class);
    private final BackgroundTaskExecutorRegistry _backgroundTaskExecutorRegistry;
    private final BackgroundTaskManager _backgroundTaskManager;
    private final BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;
    private final BackgroundTaskThreadLocalManager _backgroundTaskThreadLocalManager;
    private final LockManager _lockManager;
    private final MessageBus _messageBus;

    public BackgroundTaskMessageListener(BackgroundTaskExecutorRegistry backgroundTaskExecutorRegistry, BackgroundTaskManager backgroundTaskManager, BackgroundTaskStatusRegistry backgroundTaskStatusRegistry, BackgroundTaskThreadLocalManager backgroundTaskThreadLocalManager, LockManager lockManager, MessageBus messageBus) {
        this._backgroundTaskExecutorRegistry = backgroundTaskExecutorRegistry;
        this._backgroundTaskManager = backgroundTaskManager;
        this._backgroundTaskStatusRegistry = backgroundTaskStatusRegistry;
        this._backgroundTaskThreadLocalManager = backgroundTaskThreadLocalManager;
        this._lockManager = lockManager;
        this._messageBus = messageBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doReceive(Message message) throws Exception {
        block36: {
            long backgroundTaskId = (Long)message.get("backgroundTaskId");
            try (SafeCloseable safeCloseable = BackgroundTaskThreadLocal.setBackgroundTaskIdWithSafeCloseable((long)backgroundTaskId);){
                ServiceContext serviceContext = new ServiceContext();
                BackgroundTask backgroundTask = this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, 1, serviceContext);
                if (backgroundTask == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to find background task " + backgroundTaskId));
                    }
                    return;
                }
                BackgroundTaskExecutor backgroundTaskExecutor = null;
                BackgroundTaskStatusMessageListener backgroundTaskStatusMessageListener = null;
                int status = backgroundTask.getStatus();
                String statusMessage = null;
                try {
                    ClassLoader classLoader = this.getBackgroundTaskExecutorClassLoader(backgroundTask);
                    backgroundTaskExecutor = this.wrapBackgroundTaskExecutor(backgroundTask, classLoader);
                    this._backgroundTaskStatusRegistry.registerBackgroundTaskStatus(backgroundTaskId);
                    BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator = backgroundTaskExecutor.getBackgroundTaskStatusMessageTranslator();
                    if (backgroundTaskStatusMessageTranslator != null) {
                        backgroundTaskStatusMessageListener = new BackgroundTaskStatusMessageListener(backgroundTaskId, backgroundTaskStatusMessageTranslator, this._backgroundTaskStatusRegistry);
                        this._messageBus.registerMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
                    }
                    backgroundTask = this._backgroundTaskManager.fetchBackgroundTask(backgroundTask.getBackgroundTaskId());
                    BackgroundTaskResult backgroundTaskResult = backgroundTaskExecutor.execute(backgroundTask);
                    status = backgroundTaskResult.getStatus();
                    statusMessage = backgroundTaskResult.getStatusMessage();
                }
                catch (DuplicateLockException duplicateLockException) {
                    block37: {
                        status = 4;
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Unable to acquire lock, queuing background task " + backgroundTaskId), (Throwable)duplicateLockException);
                            break block37;
                        }
                        if (!_log.isInfoEnabled()) break block37;
                        _log.info((Object)("Unable to acquire lock, queuing background task " + backgroundTaskId));
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Completing background task ", backgroundTaskId, " with status: ", status}));
                    }
                    this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
                    this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
                    if (backgroundTaskStatusMessageListener != null) {
                        this._messageBus.unregisterMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
                    }
                    Message responseMessage = new Message();
                    responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                    responseMessage.put("name", (Object)backgroundTask.getName());
                    responseMessage.put("status", (Object)status);
                    responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                    this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
                    break block36;
                }
                catch (Exception exception) {
                    Throwable throwable;
                    status = 2;
                    if (exception instanceof SystemException && (throwable = exception.getCause()) instanceof Exception) {
                        exception = (Exception)throwable;
                    }
                    if (backgroundTaskExecutor != null) {
                        statusMessage = backgroundTaskExecutor.handleException(backgroundTask, exception);
                    }
                    if (_log.isInfoEnabled()) {
                        statusMessage = statusMessage != null ? statusMessage.concat(StackTraceUtil.getStackTrace((Throwable)exception)) : StackTraceUtil.getStackTrace((Throwable)exception);
                    }
                    _log.error((Object)"Unable to execute background task", (Throwable)exception);
                    {
                        catch (Throwable throwable2) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Completing background task ", backgroundTaskId, " with status: ", status}));
                            }
                            this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
                            this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
                            if (backgroundTaskStatusMessageListener != null) {
                                this._messageBus.unregisterMessageListener("liferay/background_task_status", backgroundTaskStatusMessageListener);
                            }
                            Message responseMessage = new Message();
                            responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                            responseMessage.put("name", (Object)backgroundTask.getName());
                            responseMessage.put("status", (Object)status);
                            responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                            this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
                            throw throwable2;
                        }
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Completing background task ", backgroundTaskId, " with status: ", status}));
                    }
                    this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
                    this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
                    if (backgroundTaskStatusMessageListener != null) {
                        this._messageBus.unregisterMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
                    }
                    Message responseMessage = new Message();
                    responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                    responseMessage.put("name", (Object)backgroundTask.getName());
                    responseMessage.put("status", (Object)status);
                    responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                    this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
                    break block36;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Completing background task ", backgroundTaskId, " with status: ", status}));
                }
                this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
                this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
                if (backgroundTaskStatusMessageListener != null) {
                    this._messageBus.unregisterMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
                }
                Message responseMessage = new Message();
                responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                responseMessage.put("name", (Object)backgroundTask.getName());
                responseMessage.put("status", (Object)status);
                responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
            }
        }
    }

    protected BackgroundTaskExecutor getBackgroundTaskExecutor(BackgroundTask backgroundTask) {
        BackgroundTaskExecutor backgroundTaskExecutor = null;
        String servletContextNames = backgroundTask.getServletContextNames();
        if (Validator.isNull((String)servletContextNames)) {
            backgroundTaskExecutor = this._backgroundTaskExecutorRegistry.getBackgroundTaskExecutor(backgroundTask.getTaskExecutorClassName());
            if (backgroundTaskExecutor == null) {
                throw new IllegalStateException("Unknown background task executor " + backgroundTask.getTaskExecutorClassName());
            }
            backgroundTaskExecutor = backgroundTaskExecutor.clone();
        } else {
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            if (Validator.isNotNull((String)servletContextNames)) {
                classLoader = this._getAggregatePluginsClassLoader(servletContextNames);
            }
            try {
                backgroundTaskExecutor = (BackgroundTaskExecutor)InstanceFactory.newInstance((ClassLoader)classLoader, (String)backgroundTask.getTaskExecutorClassName());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot instantiate BackgroundTaskExecutor: " + backgroundTask.getTaskExecutorClassName(), exception);
            }
        }
        return backgroundTaskExecutor;
    }

    protected ClassLoader getBackgroundTaskExecutorClassLoader(BackgroundTask backgroundTask) {
        if (Validator.isNull((String)backgroundTask.getServletContextNames())) {
            return null;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        String servletContextNames = backgroundTask.getServletContextNames();
        if (Validator.isNotNull((String)servletContextNames)) {
            classLoader = this._getAggregatePluginsClassLoader(servletContextNames);
        }
        return classLoader;
    }

    protected BackgroundTaskExecutor wrapBackgroundTaskExecutor(BackgroundTask backgroundTask, ClassLoader classLoader) {
        Object backgroundTaskExecutor = this.getBackgroundTaskExecutor(backgroundTask);
        if (classLoader != null) {
            backgroundTaskExecutor = new ClassLoaderAwareBackgroundTaskExecutor(backgroundTaskExecutor, classLoader);
        }
        if (backgroundTaskExecutor.isSerial()) {
            backgroundTaskExecutor = new SerialBackgroundTaskExecutor((BackgroundTaskExecutor)backgroundTaskExecutor, this._lockManager);
        }
        return new ThreadLocalAwareBackgroundTaskExecutor((BackgroundTaskExecutor)backgroundTaskExecutor, this._backgroundTaskThreadLocalManager);
    }

    private ClassLoader _getAggregatePluginsClassLoader(String servletContextNamesString) {
        String[] servletContextNames = StringUtil.split((String)servletContextNamesString);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(servletContextNames.length);
        for (String servletContextName : servletContextNames) {
            ClassLoader classLoader = ServletContextClassLoaderPool.getClassLoader((String)servletContextName);
            if (classLoader == null) {
                _log.error((Object)("Unable to find class loader for servlet context " + servletContextName));
                continue;
            }
            classLoaders.add(classLoader);
        }
        return AggregateClassLoader.getAggregateClassLoader((ClassLoader[])classLoaders.toArray(new ClassLoader[0]));
    }
}

