/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.background.task.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.service.base.BackgroundTaskServiceBaseImpl;

import org.osgi.service.component.annotations.Component;

/**
 * @author Michael C. Han
 */
@Component(
	property = {
		"json.web.service.context.name=backgroundtask",
		"json.web.service.context.path=BackgroundTask"
	},
	service = AopService.class
)
public class BackgroundTaskServiceImpl extends BackgroundTaskServiceBaseImpl {

	@Override
	public int getBackgroundTasksCount(
		long groupId, String taskExecutorClassName, boolean completed) {

		return backgroundTaskLocalService.getBackgroundTasksCount(
			groupId, taskExecutorClassName, completed);
	}

	@Override
	public int getBackgroundTasksCount(
		long groupId, String name, String taskExecutorClassName) {

		return backgroundTaskLocalService.getBackgroundTasksCount(
			groupId, name, taskExecutorClassName);
	}

	@Override
	public String getBackgroundTaskStatusJSON(long backgroundTaskId) {
		return backgroundTaskLocalService.getBackgroundTaskStatusJSON(
			backgroundTaskId);
	}

}