/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;

public class BackgroundTaskStatusMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskStatusMessageListener.class);
    private final long _backgroundTaskId;
    private final BackgroundTaskStatusMessageTranslator _backgroundTaskStatusMessageTranslator;
    private final BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;

    public BackgroundTaskStatusMessageListener(long backgroundTaskId, BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator, BackgroundTaskStatusRegistry backgroundTaskStatusRegistry) {
        this._backgroundTaskId = backgroundTaskId;
        this._backgroundTaskStatusMessageTranslator = backgroundTaskStatusMessageTranslator;
        this._backgroundTaskStatusRegistry = backgroundTaskStatusRegistry;
    }

    protected void doReceive(Message message) throws Exception {
        long backgroundTaskId = message.getLong("backgroundTaskId");
        if (backgroundTaskId != this._backgroundTaskId) {
            return;
        }
        BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatusRegistry.getBackgroundTaskStatus(backgroundTaskId);
        if (backgroundTaskStatus == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to locate status for background task ", backgroundTaskId, " to process ", message}));
            }
            return;
        }
        this._backgroundTaskStatusMessageTranslator.translate(backgroundTaskStatus, message);
    }
}

