/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.background.task.internal.lock.BackgroundTaskLockHelper;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskLockHelperUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.DelegatingBackgroundTaskExecutor;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;

public class SerialBackgroundTaskExecutor
extends DelegatingBackgroundTaskExecutor {
    private final LockManager _lockManager;

    public SerialBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, LockManager lockManager) {
        super(backgroundTaskExecutor);
        this._lockManager = lockManager;
    }

    public BackgroundTaskExecutor clone() {
        return new SerialBackgroundTaskExecutor(this.getBackgroundTaskExecutor(), this._lockManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Lock lock = null;
        try {
            if (this.isSerial()) {
                lock = this.acquireLock(backgroundTask);
            }
            BackgroundTaskExecutor backgroundTaskExecutor = this.getBackgroundTaskExecutor();
            BackgroundTaskResult backgroundTaskResult = backgroundTaskExecutor.execute(backgroundTask);
            return backgroundTaskResult;
        }
        finally {
            if (lock != null) {
                BackgroundTaskLockHelperUtil.unlockBackgroundTask((BackgroundTask)backgroundTask);
            }
        }
    }

    protected Lock acquireLock(BackgroundTask backgroundTask) throws DuplicateLockException {
        BackgroundTaskLockHelper backgroundTaskLockHelper = new BackgroundTaskLockHelper(this._lockManager);
        Lock lock = backgroundTaskLockHelper.lockBackgroundTask(backgroundTask);
        if (!lock.isNew()) {
            throw new DuplicateLockException(lock);
        }
        return lock;
    }
}

