/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.background.task.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.upgrade.UpgradeException;

/**
 * @author Tina Tian
 */
public class UpgradeKernelPackage
	extends com.liferay.portal.upgrade.v7_0_0.UpgradeKernelPackage {

	@Override
	protected void doUpgrade() throws UpgradeException {
		try {
			upgradeLongTextTable(
				"BackgroundTask", "taskContext", "backgroundTaskId",
				_CLASS_NAMES, WildcardMode.SURROUND);
		}
		catch (Exception e) {
			throw new UpgradeException(e);
		}
	}

	private static final String[][] _CLASS_NAMES = {
		{
			"com.liferay.portal.security.auth.HttpPrincipal",
			"com.liferay.portal.kernel.security.auth.HttpPrincipal"
		}
	};

}