/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.security.permission.resource;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.model.BackgroundTaskModel;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class BackgroundTaskModelResourcePermissionRegistrar {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    private ServiceTrackerMap<String, ModelResourcePermissionLogic> _backgroundTaskModelResourcePermissionLogics;
    private ServiceRegistration<ModelResourcePermission> _serviceRegistration;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._backgroundTaskModelResourcePermissionLogics = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ModelResourcePermissionLogic.class, (String)"background.task.executor.class.name");
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", BackgroundTask.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(BackgroundTask.class, BackgroundTaskModel::getBackgroundTaskId, arg_0 -> ((BackgroundTaskLocalService)this._backgroundTaskLocalService).getBackgroundTask(arg_0), null, (modelResourcePermission, consumer) -> consumer.accept(new BackgroundTaskPermissionLogic())), (Dictionary)properties);
    }

    @Deactivate
    public void deactivate() {
        this._serviceRegistration.unregister();
        this._backgroundTaskModelResourcePermissionLogics.close();
    }

    private class BackgroundTaskPermissionLogic
    implements ModelResourcePermissionLogic<BackgroundTask> {
        private BackgroundTaskPermissionLogic() {
        }

        public Boolean contains(PermissionChecker permissionChecker, String name, BackgroundTask backgroundTask, String actionId) throws PortalException {
            ModelResourcePermissionLogic backgroundTaskModelResourcePermissionLogic = (ModelResourcePermissionLogic)BackgroundTaskModelResourcePermissionRegistrar.this._backgroundTaskModelResourcePermissionLogics.getService((Object)backgroundTask.getTaskExecutorClassName());
            if (backgroundTaskModelResourcePermissionLogic == null) {
                return null;
            }
            return backgroundTaskModelResourcePermissionLogic.contains(permissionChecker, name, (GroupedModel)backgroundTask, actionId);
        }
    }
}

