/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.background.task.service.persistence.impl;

import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.persistence.BackgroundTaskPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;

/**
 * @author Brian Wing Shun Chan
 * @generated
 */
public class BackgroundTaskFinderBaseImpl
	extends BasePersistenceImpl<BackgroundTask> {

	public BackgroundTaskFinderBaseImpl() {
		setModelClass(BackgroundTask.class);
	}

	/**
	 * Returns the background task persistence.
	 *
	 * @return the background task persistence
	 */
	public BackgroundTaskPersistence getBackgroundTaskPersistence() {
		return backgroundTaskPersistence;
	}

	/**
	 * Sets the background task persistence.
	 *
	 * @param backgroundTaskPersistence the background task persistence
	 */
	public void setBackgroundTaskPersistence(
		BackgroundTaskPersistence backgroundTaskPersistence) {

		this.backgroundTaskPersistence = backgroundTaskPersistence;
	}

	@BeanReference(type = BackgroundTaskPersistence.class)
	protected BackgroundTaskPersistence backgroundTaskPersistence;

}