/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.messaging;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Map;

public class RemoveOnCompletionBackgroundTaskStatusMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(RemoveOnCompletionBackgroundTaskStatusMessageListener.class);
    private final BackgroundTaskManager _backgroundTaskManager;

    public RemoveOnCompletionBackgroundTaskStatusMessageListener(BackgroundTaskManager backgroundTaskManager) {
        this._backgroundTaskManager = backgroundTaskManager;
    }

    protected void doReceive(Message message) throws Exception {
        long backgroundTaskId = (Long)message.get("backgroundTaskId");
        BackgroundTask backgroundTask = this._backgroundTaskManager.fetchBackgroundTask(backgroundTaskId);
        if (backgroundTask == null) {
            return;
        }
        Map taskContextMap = backgroundTask.getTaskContextMap();
        boolean deleteOnCompetion = GetterUtil.getBoolean(taskContextMap.get("deleteOnSuccess"));
        if (!deleteOnCompetion) {
            return;
        }
        int status = GetterUtil.getInteger((Object)message.get("status"), (int)-1);
        if (status == -1) {
            return;
        }
        if (status == 3) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deleting background task " + backgroundTask.toString()));
            }
            this._backgroundTaskManager.deleteBackgroundTask(backgroundTaskId);
        }
    }
}

