/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistry;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={BackgroundTaskExecutorRegistry.class})
public class BackgroundTaskExecutorRegistryImpl
implements BackgroundTaskExecutorRegistry {
    private final Map<String, ServiceRegistration<BackgroundTaskExecutor>> _backgroundTaskExecutorRegistrations = new HashMap<String, ServiceRegistration<BackgroundTaskExecutor>>();
    private final Map<String, BackgroundTaskExecutor> _backgroundTaskExecutors = new HashMap<String, BackgroundTaskExecutor>();
    private BundleContext _bundleContext;

    public synchronized BackgroundTaskExecutor getBackgroundTaskExecutor(String backgroundTaskExecutorClassName) {
        return this._backgroundTaskExecutors.get(backgroundTaskExecutorClassName);
    }

    public synchronized void registerBackgroundTaskExecutor(String backgroundTaskExecutorClassName, BackgroundTaskExecutor backgroundTaskExecutor) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("background.task.executor.class.name", backgroundTaskExecutor);
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(BackgroundTaskExecutor.class, (Object)backgroundTaskExecutor, (Dictionary)properties);
        this._backgroundTaskExecutorRegistrations.put(backgroundTaskExecutorClassName, (ServiceRegistration<BackgroundTaskExecutor>)serviceRegistration);
    }

    public synchronized void unregisterBackgroundTaskExecutor(String backgroundTaskExecutorClassName) {
        if (!this._backgroundTaskExecutorRegistrations.containsKey(backgroundTaskExecutorClassName)) {
            return;
        }
        ServiceRegistration<BackgroundTaskExecutor> serviceRegistration = this._backgroundTaskExecutorRegistrations.get(backgroundTaskExecutorClassName);
        serviceRegistration.unregister();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void addBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, Map<String, Object> properties) {
        String backgroundTaskExecutorClassName = (String)properties.get("background.task.executor.class.name");
        if (Validator.isNull((String)backgroundTaskExecutorClassName)) {
            throw new IllegalArgumentException("Property \"background.task.executor.class.name\" is not set for " + backgroundTaskExecutor);
        }
        this._backgroundTaskExecutors.put(backgroundTaskExecutorClassName, backgroundTaskExecutor);
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._bundleContext = null;
        for (ServiceRegistration<BackgroundTaskExecutor> serviceRegistration : this._backgroundTaskExecutorRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._backgroundTaskExecutorRegistrations.clear();
    }

    protected synchronized void removeBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, Map<String, Object> properties) {
        String backgroundTaskExecutorClassName = (String)properties.get("background.task.executor.class.name");
        if (Validator.isNull((String)backgroundTaskExecutorClassName)) {
            return;
        }
        this._backgroundTaskExecutors.remove(backgroundTaskExecutorClassName);
    }
}

