/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.messaging;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageSender;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BackgroundTaskStatusMessageSender.class})
public class BackgroundTaskStatusMessageSenderImpl
implements BackgroundTaskStatusMessageSender {
    private MessageBus _messageBus;

    public void sendBackgroundTaskStatusMessage(Message message) {
        if (!BackgroundTaskThreadLocal.hasBackgroundTask()) {
            return;
        }
        String destinationName = message.getDestinationName();
        if (Validator.isNull((String)destinationName)) {
            destinationName = "liferay/background_task_status";
            message.setDestinationName(destinationName);
        }
        this._messageBus.sendMessage(destinationName, message);
    }

    @Reference(unbind="-")
    protected void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }
}

