/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.messaging;

import com.liferay.portal.background.task.internal.messaging.BackgroundTaskStatusMessageListener;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.backgroundtask.ClassLoaderAwareBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.SerialBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.ThreadLocalAwareBackgroundTaskExecutor;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class BackgroundTaskMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskMessageListener.class);
    private final BackgroundTaskExecutorRegistry _backgroundTaskExecutorRegistry;
    private final BackgroundTaskManager _backgroundTaskManager;
    private final BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;
    private final BackgroundTaskThreadLocalManager _backgroundTaskThreadLocalManager;
    private final MessageBus _messageBus;

    public BackgroundTaskMessageListener(BackgroundTaskExecutorRegistry backgroundTaskExecutorRegistry, BackgroundTaskManager backgroundTaskManager, BackgroundTaskStatusRegistry backgroundTaskStatusRegistry, BackgroundTaskThreadLocalManager backgroundTaskThreadLocalManager, MessageBus messageBus) {
        this._backgroundTaskExecutorRegistry = backgroundTaskExecutorRegistry;
        this._backgroundTaskManager = backgroundTaskManager;
        this._backgroundTaskStatusRegistry = backgroundTaskStatusRegistry;
        this._backgroundTaskThreadLocalManager = backgroundTaskThreadLocalManager;
        this._messageBus = messageBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doReceive(Message message) throws Exception {
        long backgroundTaskId = (Long)message.get("backgroundTaskId");
        BackgroundTaskThreadLocal.setBackgroundTaskId((long)backgroundTaskId);
        ServiceContext serviceContext = new ServiceContext();
        BackgroundTask backgroundTask = this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, 1, serviceContext);
        if (backgroundTask == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find background task " + backgroundTaskId));
            }
            return;
        }
        BackgroundTaskExecutor backgroundTaskExecutor = null;
        BackgroundTaskStatusMessageListener backgroundTaskStatusMessageListener = null;
        int status = backgroundTask.getStatus();
        String statusMessage = null;
        try {
            ClassLoader classLoader = this.getBackgroundTaskExecutorClassLoader(backgroundTask);
            backgroundTaskExecutor = this.wrapBackgroundTaskExecutor(backgroundTask, classLoader);
            this._backgroundTaskStatusRegistry.registerBackgroundTaskStatus(backgroundTaskId);
            BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator = backgroundTaskExecutor.getBackgroundTaskStatusMessageTranslator();
            if (backgroundTaskStatusMessageTranslator != null) {
                backgroundTaskStatusMessageListener = new BackgroundTaskStatusMessageListener(backgroundTaskId, backgroundTaskStatusMessageTranslator, this._backgroundTaskStatusRegistry);
                this._messageBus.registerMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
            }
            backgroundTask = this._backgroundTaskManager.fetchBackgroundTask(backgroundTask.getBackgroundTaskId());
            BackgroundTaskResult backgroundTaskResult = backgroundTaskExecutor.execute(backgroundTask);
            status = backgroundTaskResult.getStatus();
            statusMessage = backgroundTaskResult.getStatusMessage();
        }
        catch (DuplicateLockException dle) {
            block20: {
                status = 4;
                if (!_log.isDebugEnabled()) break block20;
                _log.debug((Object)("Unable to acquire lock, queuing background task " + backgroundTaskId));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Completing background task " + backgroundTaskId + " with status: " + status));
            }
            this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
            this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
            if (backgroundTaskStatusMessageListener != null) {
                this._messageBus.unregisterMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
            }
            Message responseMessage = new Message();
            responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
            responseMessage.put("name", (Object)backgroundTask.getName());
            responseMessage.put("status", (Object)status);
            responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
            this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
        }
        catch (Exception e) {
            Throwable cause;
            status = 2;
            if (e instanceof SystemException && (cause = e.getCause()) instanceof Exception) {
                e = (Exception)cause;
            }
            if (backgroundTaskExecutor != null) {
                statusMessage = backgroundTaskExecutor.handleException(backgroundTask, e);
            }
            if (_log.isInfoEnabled()) {
                statusMessage = statusMessage != null ? statusMessage.concat(StackTraceUtil.getStackTrace((Throwable)e)) : StackTraceUtil.getStackTrace((Throwable)e);
            }
            _log.error((Object)"Unable to execute background task", (Throwable)e);
            {
                catch (Throwable throwable) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Completing background task " + backgroundTaskId + " with status: " + status));
                    }
                    this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
                    this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
                    if (backgroundTaskStatusMessageListener != null) {
                        this._messageBus.unregisterMessageListener("liferay/background_task_status", backgroundTaskStatusMessageListener);
                    }
                    Message responseMessage = new Message();
                    responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                    responseMessage.put("name", (Object)backgroundTask.getName());
                    responseMessage.put("status", (Object)status);
                    responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                    this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
                    throw throwable;
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Completing background task " + backgroundTaskId + " with status: " + status));
            }
            this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
            this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
            if (backgroundTaskStatusMessageListener != null) {
                this._messageBus.unregisterMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
            }
            Message responseMessage = new Message();
            responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
            responseMessage.put("name", (Object)backgroundTask.getName());
            responseMessage.put("status", (Object)status);
            responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
            this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Completing background task " + backgroundTaskId + " with status: " + status));
        }
        this._backgroundTaskManager.amendBackgroundTask(backgroundTaskId, null, status, statusMessage, serviceContext);
        this._backgroundTaskStatusRegistry.unregisterBackgroundTaskStatus(backgroundTaskId);
        if (backgroundTaskStatusMessageListener != null) {
            this._messageBus.unregisterMessageListener("liferay/background_task_status", (MessageListener)backgroundTaskStatusMessageListener);
        }
        Message responseMessage = new Message();
        responseMessage.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
        responseMessage.put("name", (Object)backgroundTask.getName());
        responseMessage.put("status", (Object)status);
        responseMessage.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
        this._messageBus.sendMessage("liferay/background_task_status", responseMessage);
    }

    protected BackgroundTaskExecutor getBackgroundTaskExecutor(BackgroundTask backgroundTask) {
        BackgroundTaskExecutor backgroundTaskExecutor;
        block5: {
            backgroundTaskExecutor = null;
            String servletContextNames = backgroundTask.getServletContextNames();
            if (Validator.isNull((String)servletContextNames)) {
                backgroundTaskExecutor = this._backgroundTaskExecutorRegistry.getBackgroundTaskExecutor(backgroundTask.getTaskExecutorClassName());
                backgroundTaskExecutor = backgroundTaskExecutor.clone();
            } else {
                ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
                if (Validator.isNotNull((String)servletContextNames)) {
                    classLoader = ClassLoaderUtil.getAggregatePluginsClassLoader((String[])StringUtil.split((String)servletContextNames), (boolean)false);
                }
                try {
                    backgroundTaskExecutor = (BackgroundTaskExecutor)InstanceFactory.newInstance((ClassLoader)classLoader, (String)backgroundTask.getTaskExecutorClassName());
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Object)"Unable to create new background task executor", (Throwable)e);
                }
            }
        }
        return backgroundTaskExecutor;
    }

    protected ClassLoader getBackgroundTaskExecutorClassLoader(BackgroundTask backgroundTask) {
        if (Validator.isNull((String)backgroundTask.getServletContextNames())) {
            return null;
        }
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        String servletContextNames = backgroundTask.getServletContextNames();
        if (Validator.isNotNull((String)servletContextNames)) {
            classLoader = ClassLoaderUtil.getAggregatePluginsClassLoader((String[])StringUtil.split((String)servletContextNames), (boolean)false);
        }
        return classLoader;
    }

    protected BackgroundTaskExecutor wrapBackgroundTaskExecutor(BackgroundTask backgroundTask, ClassLoader classLoader) {
        BackgroundTaskExecutor backgroundTaskExecutor = this.getBackgroundTaskExecutor(backgroundTask);
        if (classLoader != null) {
            backgroundTaskExecutor = new ClassLoaderAwareBackgroundTaskExecutor(backgroundTaskExecutor, classLoader);
        }
        if (backgroundTaskExecutor.isSerial()) {
            backgroundTaskExecutor = new SerialBackgroundTaskExecutor(backgroundTaskExecutor);
        }
        backgroundTaskExecutor = new ThreadLocalAwareBackgroundTaskExecutor(backgroundTaskExecutor, this._backgroundTaskThreadLocalManager);
        return backgroundTaskExecutor;
    }
}

