/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.background.task.internal.BackgroundTaskImpl;
import com.liferay.portal.background.task.internal.comparator.BackgroundTaskCompletionDateComparator;
import com.liferay.portal.background.task.internal.comparator.BackgroundTaskCreateDateComparator;
import com.liferay.portal.background.task.internal.comparator.BackgroundTaskNameComparator;
import com.liferay.portal.background.task.internal.messaging.BackgroundTaskMessageListener;
import com.liferay.portal.background.task.internal.messaging.BackgroundTaskQueuingMessageListener;
import com.liferay.portal.background.task.internal.messaging.RemoveOnCompletionBackgroundTaskStatusMessageListener;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BackgroundTaskManager.class})
public class BackgroundTaskManagerImpl
implements BackgroundTaskManager {
    @Reference
    private BackgroundTaskExecutorRegistry _backgroundTaskExecutorRegistry;
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;
    @Reference
    private BackgroundTaskThreadLocalManager _backgroundTaskThreadLocalManager;
    private volatile BundleContext _bundleContext;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private MessageBus _messageBus;
    private final Set<ServiceRegistration<Destination>> _serviceRegistrations = new HashSet<ServiceRegistration<Destination>>();

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask addBackgroundTask(long userId, long groupId, String name, String taskExecutorClassName, Map<String, Serializable> taskContextMap, ServiceContext serviceContext) throws PortalException {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.addBackgroundTask(userId, groupId, name, taskExecutorClassName, taskContextMap, serviceContext);
        return new BackgroundTaskImpl(backgroundTask);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask addBackgroundTask(long userId, long groupId, String name, String[] servletContextNames, Class<?> taskExecutorClass, Map<String, Serializable> taskContextMap, ServiceContext serviceContext) throws PortalException {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.addBackgroundTask(userId, groupId, name, servletContextNames, taskExecutorClass, taskContextMap, serviceContext);
        return new BackgroundTaskImpl(backgroundTask);
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, File file) throws PortalException {
        this._backgroundTaskLocalService.addBackgroundTaskAttachment(userId, backgroundTaskId, fileName, file);
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, InputStream inputStream) throws PortalException {
        this._backgroundTaskLocalService.addBackgroundTaskAttachment(userId, backgroundTaskId, fileName, inputStream);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask amendBackgroundTask(long backgroundTaskId, Map<String, Serializable> taskContextMap, int status, ServiceContext serviceContext) {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.amendBackgroundTask(backgroundTaskId, taskContextMap, status, serviceContext);
        return new BackgroundTaskImpl(backgroundTask);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask amendBackgroundTask(long backgroundTaskId, Map<String, Serializable> taskContextMap, int status, String statusMessage, ServiceContext serviceContext) {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.amendBackgroundTask(backgroundTaskId, taskContextMap, status, statusMessage, serviceContext);
        return new BackgroundTaskImpl(backgroundTask);
    }

    public void cleanUpBackgroundTask(com.liferay.portal.kernel.backgroundtask.BackgroundTask backgroundTask, int status) {
        this._backgroundTaskLocalService.cleanUpBackgroundTask(backgroundTask.getBackgroundTaskId(), status);
    }

    public void cleanUpBackgroundTasks() {
        this._backgroundTaskLocalService.cleanUpBackgroundTasks();
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask deleteBackgroundTask(long backgroundTaskId) throws PortalException {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.deleteBackgroundTask(backgroundTaskId);
        return new BackgroundTaskImpl(backgroundTask);
    }

    public void deleteCompanyBackgroundTasks(long companyId) throws PortalException {
        this._backgroundTaskLocalService.deleteCompanyBackgroundTasks(companyId);
    }

    public void deleteGroupBackgroundTasks(long groupId) throws PortalException {
        this._backgroundTaskLocalService.deleteGroupBackgroundTasks(groupId);
    }

    public void deleteGroupBackgroundTasks(long groupId, String name, String taskExecutorClassName) throws PortalException {
        this._backgroundTaskLocalService.deleteGroupBackgroundTasks(groupId, name, taskExecutorClassName);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask fetchBackgroundTask(long backgroundTaskId) {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(backgroundTaskId);
        if (backgroundTask == null) {
            return null;
        }
        return new BackgroundTaskImpl(backgroundTask);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask fetchFirstBackgroundTask(long groupId, String taskExecutorClassName, boolean completed, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchFirstBackgroundTask(groupId, taskExecutorClassName, completed, this.translate(orderByComparator));
        if (backgroundTask == null) {
            return null;
        }
        return new BackgroundTaskImpl(backgroundTask);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status) {
        BackgroundTask bcakgroundTaskModel = this._backgroundTaskLocalService.fetchFirstBackgroundTask(taskExecutorClassName, status);
        if (bcakgroundTaskModel == null) {
            return null;
        }
        return new BackgroundTaskImpl(bcakgroundTaskModel);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchFirstBackgroundTask(taskExecutorClassName, status, this.translate(orderByComparator));
        if (backgroundTask == null) {
            return null;
        }
        return new BackgroundTaskImpl(backgroundTask);
    }

    public com.liferay.portal.kernel.backgroundtask.BackgroundTask getBackgroundTask(long backgroundTaskId) throws PortalException {
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.getBackgroundTask(backgroundTaskId);
        return new BackgroundTaskImpl(backgroundTask);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, int status) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupId, status);
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupId, taskExecutorClassName);
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, boolean completed, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupId, taskExecutorClassName, completed, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, int status) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupId, taskExecutorClassName, status);
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupId, taskExecutorClassName, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String name, String taskExecutorClassName, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupId, name, taskExecutorClassName, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String[] taskExecutorClassNames) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(new long[]{groupId}, taskExecutorClassNames);
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String[] taskExecutorClassNames, int status) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupId, taskExecutorClassNames, status);
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long groupId, String[] taskExecutorClassNames, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(new long[]{groupId}, taskExecutorClassNames, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long[] groupIds, String taskExecutorClassName, boolean completed, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupIds, new String[]{taskExecutorClassName}, completed, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long[] groupIds, String taskExecutorClassName, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupIds, new String[]{taskExecutorClassName}, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(long[] groupIds, String name, String taskExecutorClassName, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(groupIds, name, taskExecutorClassName, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(taskExecutorClassName, status);
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(taskExecutorClassName, status, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(String[] taskExecutorClassNames, int status) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(taskExecutorClassNames, status);
        return this.translate(backgroundTasks);
    }

    public List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> getBackgroundTasks(String[] taskExecutorClassNames, int status, int start, int end, OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        List backgroundTasks = this._backgroundTaskLocalService.getBackgroundTasks(taskExecutorClassNames, status, start, end, this.translate(orderByComparator));
        return this.translate(backgroundTasks);
    }

    public int getBackgroundTasksCount(long groupId, String taskExecutorClassName) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupId, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long groupId, String taskExecutorClassName, boolean completed) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupId, taskExecutorClassName, completed);
    }

    public int getBackgroundTasksCount(long groupId, String name, String taskExecutorClassName) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupId, name, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long groupId, String name, String taskExecutorClassName, boolean completed) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupId, name, taskExecutorClassName, completed);
    }

    public int getBackgroundTasksCount(long groupId, String[] taskExecutorClassNames) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(new long[]{groupId}, taskExecutorClassNames);
    }

    public int getBackgroundTasksCount(long groupId, String[] taskExecutorClassNames, boolean completed) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(new long[]{groupId}, taskExecutorClassNames, completed);
    }

    public int getBackgroundTasksCount(long[] groupIds, String taskExecutorClassName) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupIds, new String[]{taskExecutorClassName});
    }

    public int getBackgroundTasksCount(long[] groupIds, String taskExecutorClassName, boolean completed) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupIds, new String[]{taskExecutorClassName}, completed);
    }

    public int getBackgroundTasksCount(long[] groupIds, String name, String taskExecutorClassName) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupIds, name, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long[] groupIds, String name, String taskExecutorClassName, boolean completed) {
        return this._backgroundTaskLocalService.getBackgroundTasksCount(groupIds, name, taskExecutorClassName, completed);
    }

    public String getBackgroundTaskStatusJSON(long backgroundTaskId) {
        return this._backgroundTaskLocalService.getBackgroundTaskStatusJSON(backgroundTaskId);
    }

    public void resumeBackgroundTask(long backgroundTaskId) {
        this._backgroundTaskLocalService.resumeBackgroundTask(backgroundTaskId);
    }

    public void triggerBackgroundTask(long backgroundTaskId) {
        this._backgroundTaskLocalService.triggerBackgroundTask(backgroundTaskId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        Destination backgroundTaskDestination = this.registerDestination(bundleContext, "parallel", "liferay/background_task");
        BackgroundTaskMessageListener backgroundTaskMessageListener = new BackgroundTaskMessageListener(this._backgroundTaskExecutorRegistry, this, this._backgroundTaskStatusRegistry, this._backgroundTaskThreadLocalManager, this._messageBus);
        backgroundTaskDestination.register((MessageListener)backgroundTaskMessageListener);
        Destination backgroundTaskStatusDestination = this.registerDestination(bundleContext, "serial", "liferay/background_task_status");
        BackgroundTaskQueuingMessageListener backgroundTaskQueuingMessageListener = new BackgroundTaskQueuingMessageListener(this);
        backgroundTaskStatusDestination.register((MessageListener)backgroundTaskQueuingMessageListener);
        RemoveOnCompletionBackgroundTaskStatusMessageListener removeOnCompletionBackgroundTaskStatusMessageListener = new RemoveOnCompletionBackgroundTaskStatusMessageListener(this);
        backgroundTaskStatusDestination.register((MessageListener)removeOnCompletionBackgroundTaskStatusMessageListener);
        if (!this._clusterMasterExecutor.isEnabled()) {
            this.cleanUpBackgroundTasks();
        }
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations) {
            Destination destination = (Destination)this._bundleContext.getService(serviceRegistration.getReference());
            serviceRegistration.unregister();
            destination.destroy();
        }
        this._bundleContext = null;
    }

    protected Destination registerDestination(BundleContext bundleContext, String destinationType, String destinationName) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration(destinationType, destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("destination.name", destination.getName());
        ServiceRegistration serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
        this._serviceRegistrations.add((ServiceRegistration<Destination>)serviceRegistration);
        return destination;
    }

    @Reference(unbind="-")
    protected void setLockManager(LockManager lockManager) {
    }

    protected List<com.liferay.portal.kernel.backgroundtask.BackgroundTask> translate(List<BackgroundTask> backgroundTaskModels) {
        if (backgroundTaskModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<com.liferay.portal.kernel.backgroundtask.BackgroundTask> backgroundTasks = new ArrayList<com.liferay.portal.kernel.backgroundtask.BackgroundTask>(backgroundTaskModels.size());
        for (BackgroundTask backgroundTaskModel : backgroundTaskModels) {
            backgroundTasks.add(new BackgroundTaskImpl(backgroundTaskModel));
        }
        return backgroundTasks;
    }

    protected OrderByComparator<BackgroundTask> translate(OrderByComparator<com.liferay.portal.kernel.backgroundtask.BackgroundTask> orderByComparator) {
        if (orderByComparator instanceof com.liferay.background.task.kernel.util.comparator.BackgroundTaskCompletionDateComparator) {
            return new BackgroundTaskCompletionDateComparator(orderByComparator.isAscending());
        }
        if (orderByComparator instanceof com.liferay.background.task.kernel.util.comparator.BackgroundTaskCreateDateComparator) {
            return new BackgroundTaskCreateDateComparator(orderByComparator.isAscending());
        }
        if (orderByComparator instanceof com.liferay.background.task.kernel.util.comparator.BackgroundTaskNameComparator) {
            return new BackgroundTaskNameComparator(orderByComparator.isAscending());
        }
        throw new IllegalArgumentException("Invalid class " + ClassUtil.getClassName(orderByComparator));
    }
}

