/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.function.Consumer;

public class ReflectionUtil {
    private static final MethodHandle _fetchDeclaredFieldMethodHandle;
    private static final MethodHandle _fetchDeclaredMethodMethodHandle;
    private static final MethodHandle _fetchFieldMethodHandle;
    private static final MethodHandle _fetchMethodMethodHandle;
    private static final MethodHandles.Lookup _lookup;

    public static Field fetchDeclaredField(boolean accessible, Class<?> clazz, String name) {
        if (_fetchDeclaredFieldMethodHandle == null) {
            try {
                return ReflectionUtil.getDeclaredField(accessible, clazz, name);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return _fetchDeclaredFieldMethodHandle.invokeExact(accessible, clazz, name);
        }
        catch (Throwable throwable) {
            return (Field)ReflectionUtil.throwException(throwable);
        }
    }

    public static Field fetchDeclaredField(Class<?> clazz, String name) {
        return ReflectionUtil.fetchDeclaredField(true, clazz, name);
    }

    public static Method fetchDeclaredMethod(boolean accessible, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        if (_fetchDeclaredMethodMethodHandle == null) {
            try {
                return ReflectionUtil.getDeclaredMethod(accessible, clazz, name, parameterTypes);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return _fetchDeclaredMethodMethodHandle.invokeExact(accessible, clazz, name, parameterTypes);
        }
        catch (Throwable throwable) {
            return (Method)ReflectionUtil.throwException(throwable);
        }
    }

    public static Method fetchDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ReflectionUtil.fetchDeclaredMethod(true, clazz, name, parameterTypes);
    }

    public static Field fetchField(boolean accessible, Class<?> clazz, String name) {
        if (_fetchFieldMethodHandle == null) {
            try {
                Field field = clazz.getField(name);
                if (accessible) {
                    field.setAccessible(true);
                }
                return field;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return _fetchFieldMethodHandle.invokeExact(accessible, clazz, name);
        }
        catch (Throwable throwable) {
            return (Field)ReflectionUtil.throwException(throwable);
        }
    }

    public static Field fetchField(Class<?> clazz, String name) {
        return ReflectionUtil.fetchField(true, clazz, name);
    }

    public static Method fetchMethod(boolean accessible, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        if (_fetchMethodMethodHandle == null) {
            try {
                Method method = clazz.getMethod(name, parameterTypes);
                if (accessible) {
                    method.setAccessible(true);
                }
                return method;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return _fetchMethodMethodHandle.invokeExact(accessible, clazz, name, parameterTypes);
        }
        catch (Throwable throwable) {
            return (Method)ReflectionUtil.throwException(throwable);
        }
    }

    public static Method fetchMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return ReflectionUtil.fetchMethod(true, clazz, name, parameterTypes);
    }

    public static Field getDeclaredField(boolean accessible, Class<?> clazz, String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        if (accessible) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws Exception {
        return ReflectionUtil.getDeclaredField(true, clazz, name);
    }

    public static Field[] getDeclaredFields(boolean accessible, Class<?> clazz) throws Exception {
        Field[] fields = clazz.getDeclaredFields();
        if (accessible) {
            for (Field field : fields) {
                field.setAccessible(true);
            }
        }
        return fields;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws Exception {
        return ReflectionUtil.getDeclaredFields(true, clazz);
    }

    public static Method getDeclaredMethod(boolean accessible, Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        if (accessible) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        return ReflectionUtil.getDeclaredMethod(true, clazz, name, parameterTypes);
    }

    public static MethodHandles.Lookup getImplLookup() {
        return _lookup;
    }

    public static Class<?>[] getInterfaces(Object object) {
        return ReflectionUtil.getInterfaces(object, null);
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader) {
        return ReflectionUtil.getInterfaces(object, classLoader, cnfe -> {});
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader, Consumer<ClassNotFoundException> classNotFoundHandler) {
        LinkedHashSet interfaceClasses = new LinkedHashSet();
        for (Class<?> superClass = object.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Class<?> interfaceClass : superClass.getInterfaces()) {
                try {
                    if (classLoader == null) {
                        interfaceClasses.add(interfaceClass);
                        continue;
                    }
                    interfaceClasses.add(classLoader.loadClass(interfaceClass.getName()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundHandler.accept(classNotFoundException);
                }
            }
        }
        return interfaceClasses.toArray(new Class[0]);
    }

    public static <T> T throwException(Throwable throwable) {
        return ReflectionUtil._throwException(throwable);
    }

    private static Field _fetchDeclaredField(MethodHandle privateGetDeclaredFieldsMethodHandle, MethodHandle searchFieldsMethodHandle, MethodHandle copyFieldMethodHandle, boolean accessible, Class<?> clazz, String name) throws Throwable {
        Field field = searchFieldsMethodHandle.invokeExact(privateGetDeclaredFieldsMethodHandle.invokeExact(clazz, false), name);
        if (field == null) {
            return null;
        }
        field = copyFieldMethodHandle.invokeExact(field);
        if (accessible) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Method _fetchDeclaredMethod(MethodHandle privateGetDeclaredMethodsMethodHandle, MethodHandle searchMethodsMethodHandle, MethodHandle copyMethodMethodHandle, boolean accessible, Class<?> clazz, String name, Class<?> ... parameterTypes) throws Throwable {
        Method method = searchMethodsMethodHandle.invokeExact(privateGetDeclaredMethodsMethodHandle.invokeExact(clazz, false), name, parameterTypes);
        if (method == null) {
            return null;
        }
        method = copyMethodMethodHandle.invokeExact(method);
        if (accessible) {
            method.setAccessible(true);
        }
        return method;
    }

    private static Field _fetchField(MethodHandle getField0MethodHandle, MethodHandle copyFieldMethodHandle, boolean accessible, Class<?> clazz, String name) throws Throwable {
        Field field = getField0MethodHandle.invokeExact(clazz, name);
        if (field == null) {
            return null;
        }
        field = copyFieldMethodHandle.invokeExact(field);
        if (accessible) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Method _fetchMethod(MethodHandle getMethod0MethodHandle, MethodHandle copyMethodMethodHandle, boolean accessible, Class<?> clazz, String name, Class<?> ... parameterTypes) throws Throwable {
        Method method = getMethod0MethodHandle.invokeExact(clazz, name, parameterTypes);
        if (method == null) {
            return null;
        }
        method = copyMethodMethodHandle.invokeExact(method);
        if (accessible) {
            method.setAccessible(true);
        }
        return method;
    }

    private static <T, E extends Throwable> T _throwException(Throwable throwable) throws E {
        throw throwable;
    }

    static {
        MethodHandle fetchMethodMethodHandle;
        MethodHandle fetchFieldMethodHandle;
        MethodHandle fetchDeclaredMethodMethodHandle;
        MethodHandle fetchDeclaredFieldMethodHandle;
        try {
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            field.setAccessible(true);
            _lookup = (MethodHandles.Lookup)field.get(null);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        try {
            Method method = Class.class.getDeclaredMethod("getReflectionFactory", new Class[0]);
            method.setAccessible(true);
            Object reflectionFactory = method.invoke(null, new Object[0]);
            MethodHandle copyFieldMethodHandle = _lookup.findVirtual(reflectionFactory.getClass(), "copyField", MethodType.methodType(Field.class, Field.class));
            copyFieldMethodHandle = copyFieldMethodHandle.bindTo(reflectionFactory);
            MethodHandle copyMethodMethodHandle = _lookup.findVirtual(reflectionFactory.getClass(), "copyMethod", MethodType.methodType(Method.class, Method.class));
            copyMethodMethodHandle = copyMethodMethodHandle.bindTo(reflectionFactory);
            fetchDeclaredFieldMethodHandle = _lookup.findStatic(ReflectionUtil.class, "_fetchDeclaredField", MethodType.methodType(Field.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Boolean.TYPE, Class.class, String.class));
            fetchDeclaredFieldMethodHandle = MethodHandles.insertArguments(fetchDeclaredFieldMethodHandle, 0, _lookup.findSpecial(Class.class, "privateGetDeclaredFields", MethodType.methodType(Field[].class, Boolean.TYPE), Class.class), _lookup.findStatic(Class.class, "searchFields", MethodType.methodType(Field.class, Field[].class, String.class)), copyFieldMethodHandle);
            fetchDeclaredMethodMethodHandle = _lookup.findStatic(ReflectionUtil.class, "_fetchDeclaredMethod", MethodType.methodType(Method.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, Boolean.TYPE, Class.class, String.class, Class[].class));
            fetchDeclaredMethodMethodHandle = MethodHandles.insertArguments(fetchDeclaredMethodMethodHandle, 0, _lookup.findSpecial(Class.class, "privateGetDeclaredMethods", MethodType.methodType(Method[].class, Boolean.TYPE), Class.class), _lookup.findStatic(Class.class, "searchMethods", MethodType.methodType(Method.class, Method[].class, String.class, Class[].class)), copyMethodMethodHandle);
            fetchFieldMethodHandle = _lookup.findStatic(ReflectionUtil.class, "_fetchField", MethodType.methodType(Field.class, MethodHandle.class, MethodHandle.class, Boolean.TYPE, Class.class, String.class));
            fetchFieldMethodHandle = MethodHandles.insertArguments(fetchFieldMethodHandle, 0, _lookup.findSpecial(Class.class, "getField0", MethodType.methodType(Field.class, String.class), Class.class), copyFieldMethodHandle);
            fetchMethodMethodHandle = _lookup.findStatic(ReflectionUtil.class, "_fetchMethod", MethodType.methodType(Method.class, MethodHandle.class, MethodHandle.class, Boolean.TYPE, Class.class, String.class, Class[].class));
            fetchMethodMethodHandle = MethodHandles.insertArguments(fetchMethodMethodHandle, 0, _lookup.findSpecial(Class.class, "getMethod0", MethodType.methodType(Method.class, String.class, Class[].class), Class.class), copyMethodMethodHandle);
        }
        catch (Exception exception) {
            fetchDeclaredFieldMethodHandle = null;
            fetchDeclaredMethodMethodHandle = null;
            fetchFieldMethodHandle = null;
            fetchMethodMethodHandle = null;
        }
        _fetchDeclaredFieldMethodHandle = fetchDeclaredFieldMethodHandle;
        _fetchDeclaredMethodMethodHandle = fetchDeclaredMethodMethodHandle;
        _fetchFieldMethodHandle = fetchFieldMethodHandle;
        _fetchMethodMethodHandle = fetchMethodMethodHandle;
    }
}

