/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericUtil {
    public static Class<?> getGenericClass(Class<?> clazz) {
        return GenericUtil.getGenericClass(clazz, 0);
    }

    public static Class<?> getGenericClass(Class<?> clazz, int index) {
        Type[] genericInterfaceTypes;
        for (Type genericInterfaceType : genericInterfaceTypes = clazz.getGenericInterfaces()) {
            if (!(genericInterfaceType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterfaceType;
            Type[] actualArgumentTypes = parameterizedType.getActualTypeArguments();
            if (index >= actualArgumentTypes.length) {
                return Object.class;
            }
            return (Class)actualArgumentTypes[index];
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return GenericUtil.getGenericClass(superClass);
        }
        return Object.class;
    }

    public static Class<?> getGenericClass(Object object) {
        return GenericUtil.getGenericClass(object, 0);
    }

    public static Class<?> getGenericClass(Object object, int index) {
        Class<?> clazz = object.getClass();
        return GenericUtil.getGenericClass(clazz, index);
    }

    public static String getGenericClassName(Object object) {
        Class<?> clazz = GenericUtil.getGenericClass(object);
        return clazz.getName();
    }
}

