/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.reflect;

import com.liferay.petra.reflect.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class AnnotationLocator {
    public static Map<Class<? extends Annotation>, Annotation> index(Class<?> targetClass) {
        LinkedList queue = new LinkedList();
        queue.offer(targetClass);
        LinkedHashMap<Class<? extends Annotation>, Annotation> indexAnnotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            if (!Proxy.isProxyClass(clazz)) {
                AnnotationLocator._mergeAnnotations(Collections.emptySet(), indexAnnotations, false, clazz.getAnnotations());
            }
            AnnotationLocator._queueSuperTypes(clazz, queue);
        }
        return indexAnnotations;
    }

    public static Map<Class<? extends Annotation>, Annotation> index(Method method, Class<?> targetClass) {
        HashSet<Class<? extends Annotation>> concludedAnnotationClasses = new HashSet<Class<? extends Annotation>>();
        LinkedHashMap<Class<? extends Annotation>, Annotation> indexAnnotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        Class clazz = null;
        LinkedList queue = new LinkedList();
        if (targetClass == null) {
            queue.offer(method.getDeclaringClass());
        } else {
            queue.offer(targetClass);
        }
        while ((clazz = (Class)queue.poll()) != null) {
            if (!Proxy.isProxyClass(clazz)) {
                Method publicMethod;
                Method specificMethod = ReflectionUtil.fetchDeclaredMethod(false, clazz, method.getName(), method.getParameterTypes());
                if (specificMethod != null) {
                    AnnotationLocator._mergeAnnotations(concludedAnnotationClasses, indexAnnotations, true, specificMethod.getAnnotations());
                }
                if ((publicMethod = ReflectionUtil.fetchMethod(false, clazz, method.getName(), method.getParameterTypes())) != null) {
                    AnnotationLocator._mergeAnnotations(concludedAnnotationClasses, indexAnnotations, false, clazz.getAnnotations());
                }
            }
            AnnotationLocator._queueSuperTypes(clazz, queue);
        }
        return indexAnnotations;
    }

    public static List<Annotation> locate(Class<?> targetClass) {
        Map<Class<? extends Annotation>, Annotation> indexAnnotations = AnnotationLocator.index(targetClass);
        return new ArrayList<Annotation>(indexAnnotations.values());
    }

    public static <T extends Annotation> T locate(Class<?> targetClass, Class<T> annotationClass) {
        LinkedList queue = new LinkedList();
        queue.offer(targetClass);
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            if (Proxy.isProxyClass(clazz)) {
                AnnotationLocator._queueSuperTypes(clazz, queue);
                continue;
            }
            T annotation = clazz.getAnnotation(annotationClass);
            if (annotation == null) {
                AnnotationLocator._queueSuperTypes(clazz, queue);
                continue;
            }
            return annotation;
        }
        return null;
    }

    public static List<Annotation> locate(Method method, Class<?> targetClass) {
        Map<Class<? extends Annotation>, Annotation> indexAnnotations = AnnotationLocator.index(method, targetClass);
        return new ArrayList<Annotation>(indexAnnotations.values());
    }

    public static <T extends Annotation> T locate(Method method, Class<?> targetClass, Class<T> annotationClass) {
        LinkedList queue = new LinkedList();
        if (targetClass == null) {
            queue.offer(method.getDeclaringClass());
        } else {
            queue.offer(targetClass);
        }
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            if (Proxy.isProxyClass(clazz)) {
                AnnotationLocator._queueSuperTypes(clazz, queue);
                continue;
            }
            T annotation = null;
            try {
                Method specificMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = specificMethod.getAnnotation(annotationClass);
                if (annotation != null) {
                    return annotation;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazz.getMethod(method.getName(), method.getParameterTypes());
                annotation = clazz.getAnnotation(annotationClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (annotation == null) {
                AnnotationLocator._queueSuperTypes(clazz, queue);
                continue;
            }
            return annotation;
        }
        return null;
    }

    private static void _mergeAnnotations(Set<Class<? extends Annotation>> concludedAnnotationClasses, Map<Class<? extends Annotation>, Annotation> indexAnnotations, boolean fromMethod, Annotation[] sourceAnnotations) {
        for (Annotation sourceAnnotation : sourceAnnotations) {
            Class<? extends Annotation> annotationClass = sourceAnnotation.annotationType();
            if (concludedAnnotationClasses.contains(annotationClass)) continue;
            if (fromMethod) {
                indexAnnotations.put(annotationClass, sourceAnnotation);
                concludedAnnotationClasses.add(annotationClass);
                continue;
            }
            indexAnnotations.putIfAbsent(annotationClass, sourceAnnotation);
        }
    }

    private static void _queueSuperTypes(Class<?> clazz, Queue<Class<?>> queue) {
        Class<?>[] interfaceClasses;
        String name;
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !(name = superClass.getName()).startsWith("java")) {
            queue.offer(superClass);
        }
        for (Class<?> interfaceClass : interfaceClasses = clazz.getInterfaces()) {
            if (queue.contains(interfaceClass)) continue;
            queue.offer(interfaceClass);
        }
    }
}

