/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.model.adapter.util;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.util.ComparatorAdapter;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorAdapter;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ModelAdapterUtil {
    public static <T> List<T> adapt(Class<T> clazz, List<?> delegateObjects) {
        ArrayList<T> adaptedObjects = new ArrayList<T>(delegateObjects.size());
        for (Object delegateObject : delegateObjects) {
            adaptedObjects.add(ModelAdapterUtil.adapt(clazz, delegateObject));
        }
        return adaptedObjects;
    }

    public static <T> T adapt(Class<T> clazz, Object delegateObject) {
        if (delegateObject == null) {
            return null;
        }
        return (T)ProxyUtil.newProxyInstance((ClassLoader)clazz.getClassLoader(), (Class[])new Class[]{clazz, ModelWrapper.class}, (InvocationHandler)new DelegateInvocationHandler(delegateObject));
    }

    public static <T> T[] adapt(Class<T> clazz, Object[] delegateObjects) {
        Object[] adaptedObjects = (Object[])Array.newInstance(clazz, delegateObjects.length);
        for (int i = 0; i < delegateObjects.length; ++i) {
            adaptedObjects[i] = ModelAdapterUtil.adapt(clazz, delegateObjects[i]);
        }
        return adaptedObjects;
    }

    public static <T, V> Comparator<T> adapt(final Class<V> clazz, Comparator<V> comparator) {
        if (comparator == null) {
            return null;
        }
        return new ComparatorAdapter<T, V>(comparator){

            public V adapt(T t) {
                return ModelAdapterUtil.adapt(clazz, t);
            }
        };
    }

    public static <T, V> OrderByComparator<T> adapt(final Class<V> clazz, OrderByComparator<V> orderByComparator) {
        if (orderByComparator == null) {
            return null;
        }
        return new OrderByComparatorAdapter<T, V>(orderByComparator){

            public V adapt(T t) {
                return ModelAdapterUtil.adapt(clazz, t);
            }
        };
    }

    public static <T, V> QueryDefinition<T> adapt(Class<V> clazz, QueryDefinition<V> queryDefinition) {
        if (queryDefinition == null) {
            return null;
        }
        QueryDefinition adaptedQueryDefinition = new QueryDefinition(queryDefinition.getStatus(), queryDefinition.isExcludeStatus(), queryDefinition.getOwnerUserId(), queryDefinition.isIncludeOwner(), queryDefinition.getStart(), queryDefinition.getEnd(), ModelAdapterUtil.adapt(clazz, queryDefinition.getOrderByComparator()));
        adaptedQueryDefinition.setAttributes(queryDefinition.getAttributes());
        return adaptedQueryDefinition;
    }

    private static class DelegateInvocationHandler
    implements InvocationHandler {
        private final Object _delegateObject;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ReflectiveOperationException {
            Object result;
            String methodName = method.getName();
            if (methodName.equals("getWrappedModel")) {
                return this._delegateObject;
            }
            Class<?> delegateClass = this._delegateObject.getClass();
            Method delegateMethod = delegateClass.getMethod(method.getName(), method.getParameterTypes());
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    InvocationHandler invocationHandler;
                    if (!ProxyUtil.isProxyClass(args[i].getClass()) || !((invocationHandler = ProxyUtil.getInvocationHandler((Object)args[i])) instanceof DelegateInvocationHandler)) continue;
                    DelegateInvocationHandler delegateInvocationHandler = (DelegateInvocationHandler)invocationHandler;
                    args[i] = delegateInvocationHandler._delegateObject;
                }
            }
            if ((result = delegateMethod.invoke(this._delegateObject, args)) == null) {
                return null;
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.isAssignableFrom(result.getClass()) || returnType.isPrimitive()) {
                return result;
            }
            return ModelAdapterUtil.adapt(returnType, result);
        }

        private DelegateInvocationHandler(Object delegateObject) {
            this._delegateObject = delegateObject;
        }
    }
}

