/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.mail.template.internal;

import com.liferay.mail.kernel.template.MailTemplate;
import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class DefaultMailTemplate
implements MailTemplate {
    private final boolean _escapeHtml;
    private final String _template;

    public DefaultMailTemplate(String template, boolean escapeHtml) {
        this._template = template;
        this._escapeHtml = escapeHtml;
    }

    public void render(Writer writer, Locale locale, MailTemplateContext mailTemplateContext) throws IOException {
        String portalURL;
        Map replacements = mailTemplateContext.getReplacements();
        String content = this._template;
        for (Map.Entry replacement : replacements.entrySet()) {
            EscapableLocalizableFunction value = (EscapableLocalizableFunction)replacement.getValue();
            String valueString = this._escapeHtml ? value.getEscapedValue(locale) : value.getOriginalValue(locale);
            content = StringUtil.replace((String)content, (String)((String)replacement.getKey()), (String)valueString);
        }
        EscapableLocalizableFunction escapableLocalizableFunction = (EscapableLocalizableFunction)replacements.get("[$PORTAL_URL$]");
        if (escapableLocalizableFunction != null && Validator.isNotNull((String)(portalURL = escapableLocalizableFunction.getOriginalValue(locale)))) {
            content = StringUtil.replace((String)content, (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + portalURL + "/", "src=\"" + portalURL + "/"});
        }
        writer.append(content);
    }

    public String renderAsString(Locale locale, MailTemplateContext mailTemplateContext) throws IOException {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        this.render((Writer)unsyncStringWriter, locale, mailTemplateContext);
        return unsyncStringWriter.toString();
    }
}

