/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.function;

import com.liferay.petra.function.UnsafeSupplier;

public class RetryableUnsafeSupplier<T, E extends Throwable>
implements UnsafeSupplier<T, E> {
    private static final int _MAX_RETRIES = 3;
    private static final long _RETRY_INTERVAL = 1000L;
    private final ErrorHandler _errorHandler;
    private final boolean _exceptionOnFailure;
    private final int _maxRetries;
    private final long _retryInterval;
    private final UnsafeSupplier<T, E> _unsafeSupplier;

    public RetryableUnsafeSupplier(ErrorHandler errorHandler, boolean exceptionOnFailure, int maxRetries, long retryInterval, UnsafeSupplier<T, E> unsafeSupplier) {
        this._errorHandler = errorHandler;
        this._exceptionOnFailure = exceptionOnFailure;
        this._maxRetries = maxRetries;
        this._retryInterval = retryInterval;
        this._unsafeSupplier = unsafeSupplier;
    }

    public RetryableUnsafeSupplier(ErrorHandler errorHandler, UnsafeSupplier<T, E> unsafeSupplier) {
        this(errorHandler, true, 3, 1000L, unsafeSupplier);
    }

    @Override
    public T get() throws E {
        Exception previousThrowable = null;
        int retryCount = 0;
        while (true) {
            try {
                return this._unsafeSupplier.get();
            }
            catch (Exception exception) {
                if (previousThrowable != null) {
                    exception.addSuppressed(previousThrowable);
                }
                previousThrowable = exception;
                this._errorHandler.onError(exception, this._maxRetries, ++retryCount);
                if (retryCount > this._maxRetries) {
                    if (this._exceptionOnFailure) {
                        throw exception;
                    }
                    return null;
                }
                try {
                    Thread.sleep(this._retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    exception.addSuppressed(interruptedException);
                    throw exception;
                }
            }
        }
    }

    public static interface ErrorHandler {
        public void onError(Exception var1, int var2, int var3);
    }
}

