/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.petra.executor;

import com.liferay.petra.concurrent.NoticeableExecutorService;

/**
 * @author Shuyang Zhou
 */
public interface PortalExecutorManager {

	public NoticeableExecutorService getPortalExecutor(String name);

	public NoticeableExecutorService getPortalExecutor(
		String name, boolean createIfAbsent);

	public NoticeableExecutorService registerPortalExecutor(
		String name, NoticeableExecutorService noticeableExecutorService);

	public void shutdown();

	public void shutdown(boolean interrupt);

}