/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.service.internal.verify;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.organizations.service"}, service={VerifyProcess.class})
public class OrganizationServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationServiceVerifyProcess.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    protected void doVerify() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        List futures = executorService.invokeAll(Arrays.asList(this::updateOrganizationAssets, this::updateOrganizationAssetEntries));
        executorService.shutdown();
        UnsafeConsumer.accept(futures, Future::get, Exception.class);
    }

    protected Void updateOrganizationAssetEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(7);
            sb.append("select distinct AssetEntry.classPK as classPK, ");
            sb.append("Organization_.uuid_ as uuid from AssetEntry, ");
            sb.append("Organization_ where AssetEntry.classNameId = ");
            long classNameId = this._classNameLocalService.getClassNameId(Organization.class.getName());
            sb.append(classNameId);
            sb.append(" and AssetEntry.classPK = ");
            sb.append("Organization_.organizationId and AssetEntry.classUuid ");
            sb.append("is null");
            try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps1.executeQuery();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update AssetEntry set classUuid = ? where classPK = ? and classNameId = ?"));){
                while (rs.next()) {
                    long classPK = rs.getLong("classPK");
                    String uuid = rs.getString("uuid");
                    ps2.setString(1, uuid);
                    ps2.setLong(2, classPK);
                    ps2.setLong(3, classNameId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
        return null;
    }

    protected Void updateOrganizationAssets() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List organizations = this._organizationLocalService.getNoAssetOrganizations();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Processing ", organizations.size(), " organizations with no asset"}));
            }
            for (Organization organization : organizations) {
                try {
                    this._organizationLocalService.updateAsset(organization.getUserId(), organization, null, null);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update asset for organization ", organization.getOrganizationId(), ": ", e.getMessage()}));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Assets verified for organizations");
            }
        }
        return null;
    }
}

