/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.service.internal.configuration;

import com.liferay.organizations.service.internal.configuration.OrganizationTypeConfiguration;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.organizations.service.internal.configuration.OrganizationTypeConfiguration"}, service={ConfigurationModelListener.class})
public class OrganizationTypeConfigurationModelListener
implements ConfigurationModelListener {
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        try {
            String name = (String)properties.get("name");
            this._validateNameExists(name);
            this._validateUniqueConfiguration(pid, name);
        }
        catch (Exception e) {
            throw new ConfigurationModelListenerException(e.getMessage(), OrganizationTypeConfiguration.class, this.getClass(), properties);
        }
    }

    private ResourceBundle _getResourceBundle() {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
    }

    private void _validateNameExists(String name) throws Exception {
        if (Validator.isNotNull((String)name)) {
            return;
        }
        ResourceBundle resourceBundle = this._getResourceBundle();
        String message = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"an-organization-type-must-have-a-valid-name");
        throw new Exception(message);
    }

    private void _validateUniqueConfiguration(String pid, String name) throws Exception {
        String filterString = String.format("(&(service.factoryPid=%s)(name=%s))", OrganizationTypeConfiguration.class.getName(), name);
        Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (configurations == null) {
            return;
        }
        Configuration configuration = configurations[0];
        if (pid.equals(configuration.getPid())) {
            return;
        }
        ResourceBundle resourceBundle = this._getResourceBundle();
        String message = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"there-is-already-an-organization-type-with-the-name-x", (Object[])new Object[]{name});
        throw new Exception(message);
    }
}

