/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.sugarcrm.internal.web.cache;

import com.liferay.object.storage.sugarcrm.configuration.SugarCRMConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import java.util.Map;

public class SugarCRMAccessTokenWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 3600000L;
    private static final Log _log = LogFactoryUtil.getLog(SugarCRMAccessTokenWebCacheItem.class);
    private final SugarCRMConfiguration _sugarCRMConfiguration;

    public static JSONObject get(SugarCRMConfiguration sugarCRMConfiguration) {
        return (JSONObject)WebCachePoolUtil.get((String)StringBundler.concat((String[])new String[]{SugarCRMAccessTokenWebCacheItem.class.getName(), "#", sugarCRMConfiguration.accessTokenURL(), "#", sugarCRMConfiguration.baseURL(), "#", sugarCRMConfiguration.clientId(), "#", sugarCRMConfiguration.grantType(), "#", sugarCRMConfiguration.password(), "#", sugarCRMConfiguration.username()}), (WebCacheItem)new SugarCRMAccessTokenWebCacheItem(sugarCRMConfiguration));
    }

    public SugarCRMAccessTokenWebCacheItem(SugarCRMConfiguration sugarCRMConfiguration) {
        this._sugarCRMConfiguration = sugarCRMConfiguration;
    }

    public JSONObject convert(String key) {
        try {
            Http.Options options = new Http.Options();
            options.setCookieSpec(Http.CookieSpec.STANDARD);
            options.setParts((Map)HashMapBuilder.put((Object)"client_id", (Object)this._sugarCRMConfiguration.clientId()).put((Object)"grant_type", (Object)this._sugarCRMConfiguration.grantType()).put((Object)"password", (Object)this._sugarCRMConfiguration.password()).put((Object)"username", (Object)this._sugarCRMConfiguration.username()).build());
            options.setLocation(this._sugarCRMConfiguration.accessTokenURL());
            options.setPost(true);
            String responseJSON = HttpUtil.URLtoString((Http.Options)options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() != 200) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Response code ", response.getResponseCode(), ": ", responseJSON}));
                }
                return null;
            }
            return JSONFactoryUtil.createJSONObject((String)responseJSON);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    public long getRefreshTime() {
        return 3600000L;
    }
}

