/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.salesforce.internal.web.cache;

import com.liferay.object.storage.salesforce.configuration.SalesforceConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import java.util.Map;

public class SalesforceAccessTokenWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 2700000L;
    private static final Log _log = LogFactoryUtil.getLog(SalesforceAccessTokenWebCacheItem.class);
    private final SalesforceConfiguration _salesforceConfiguration;

    public static JSONObject get(SalesforceConfiguration salesforceConfiguration) {
        return (JSONObject)WebCachePoolUtil.get((String)StringBundler.concat((String[])new String[]{SalesforceAccessTokenWebCacheItem.class.getName(), "#", salesforceConfiguration.consumerKey(), "#", salesforceConfiguration.consumerSecret(), "#", salesforceConfiguration.username()}), (WebCacheItem)new SalesforceAccessTokenWebCacheItem(salesforceConfiguration));
    }

    public SalesforceAccessTokenWebCacheItem(SalesforceConfiguration salesforceConfiguration) {
        this._salesforceConfiguration = salesforceConfiguration;
    }

    public JSONObject convert(String key) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Get Salesforce access token for consumer key " + this._salesforceConfiguration.consumerKey()));
            }
            Http.Options options = new Http.Options();
            options.setParts((Map)HashMapBuilder.put((Object)"client_id", (Object)this._salesforceConfiguration.consumerKey()).put((Object)"client_secret", (Object)this._salesforceConfiguration.consumerSecret()).put((Object)"grant_type", (Object)"password").put((Object)"password", (Object)this._salesforceConfiguration.password()).put((Object)"username", (Object)this._salesforceConfiguration.username()).build());
            options.setLocation(this._salesforceConfiguration.loginURL() + "/services/oauth2/token");
            options.setPost(true);
            String responseJSON = HttpUtil.URLtoString((Http.Options)options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() != 200) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Response code ", response.getResponseCode(), ": ", responseJSON}));
                }
                return null;
            }
            return JSONFactoryUtil.createJSONObject((String)responseJSON);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    public long getRefreshTime() {
        return 2700000L;
    }
}

