/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.storage.salesforce.internal.rest.manager.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.dto.v1_0.util.CreatorUtil;
import com.liferay.object.rest.manager.v1_0.BaseObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.storage.salesforce.internal.http.SalesforceHttp;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.entry.manager.storage.type=salesforce"}, service={ObjectEntryManager.class})
public class SalesforceObjectEntryManagerImpl
extends BaseObjectEntryManager
implements ObjectEntryManager {
    private static final String _CUSTOM_OBJECT_SUFFIX = "__c";
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    private final Map<String, String> _defaultObjectFieldNames = HashMapBuilder.put((Object)"createDate", (Object)"CreatedDate").put((Object)"creator", (Object)"OwnerId").put((Object)"externalReferenceCode", (Object)"Id").put((Object)"id", (Object)"Id").put((Object)"modifiedDate", (Object)"LastModifiedDate").put((Object)"userName", (Object)"OwnerId").build();
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SalesforceHttp _salesforceHttp;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectEntry addObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("ADD_OBJECT_ENTRY", objectDefinition, scopeKey, dtoConverterContext.getUser());
        JSONObject responseJSONObject = this._salesforceHttp.post(objectDefinition.getCompanyId(), this.getGroupId(objectDefinition, scopeKey), "sobjects/" + objectDefinition.getExternalReferenceCode(), this._toJSONObject(dtoConverterContext, objectDefinition, objectEntry));
        return this.getObjectEntry(objectDefinition.getCompanyId(), dtoConverterContext, responseJSONObject.getString("id"), objectDefinition, scopeKey);
    }

    public void deleteObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("DELETE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        this._salesforceHttp.delete(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode}));
    }

    public Page<ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, String search, Sort[] sorts) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        return this._getObjectEntries(companyId, objectDefinition, scopeKey, dtoConverterContext, pagination, search, sorts);
    }

    public ObjectEntry getObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        return this._toObjectEntry(companyId, this._getDateFormat(), dtoConverterContext, this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode})), objectDefinition);
    }

    public String getStorageLabel(Locale locale) {
        return this.language.get(locale, "salesforce");
    }

    public String getStorageType() {
        return "salesforce";
    }

    public ObjectEntry updateObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("UPDATE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        this._salesforceHttp.patch(companyId, this.getGroupId(objectDefinition, scopeKey), StringBundler.concat((String[])new String[]{"sobjects/", objectDefinition.getExternalReferenceCode(), "/", externalReferenceCode}), this._toJSONObject(dtoConverterContext, objectDefinition, objectEntry));
        return this.getObjectEntry(companyId, dtoConverterContext, externalReferenceCode, objectDefinition, scopeKey);
    }

    private String _getAccountRestrictionPredicateString(long companyId, DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        if (!this._inlineSQLHelper.isEnabled(companyId, this.getGroupId(objectDefinition, scopeKey)) || !objectDefinition.isAccountEntryRestricted()) {
            return "";
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        return StringBundler.concat((String[])new String[]{" WHERE ", objectField.getExternalReferenceCode(), " IN ('", StringUtil.merge((Collection)TransformUtil.transform((Collection)this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(dtoConverterContext.getUserId()), accountEntryUserRel -> {
            AccountEntry accountEntry = accountEntryUserRel.getAccountEntry();
            return accountEntry.getExternalReferenceCode();
        }), (String)", '"), "')"});
    }

    private DateFormat _getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    private ListEntry _getListEntry(final DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, ObjectField objectField) {
        final ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntryByExternalReferenceCode(externalReferenceCode, objectDefinition.getCompanyId(), objectField.getListTypeDefinitionId());
        if (listTypeEntry == null) {
            return null;
        }
        return new ListEntry(){
            {
                this.key = listTypeEntry.getKey();
                this.name = listTypeEntry.getName(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)listTypeEntry.getNameMap());
            }
        };
    }

    private String _getListTypeEntryExternalReferenceCode(long listTypeDefinitionId, String listTypeEntryKey) {
        ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(listTypeDefinitionId, listTypeEntryKey);
        if (listTypeEntry == null) {
            return null;
        }
        return listTypeEntry.getExternalReferenceCode();
    }

    private String _getLocation(ObjectDefinition objectDefinition, Pagination pagination, String predicateString, String search, Sort[] sorts) {
        if (Validator.isNotNull((String)search)) {
            return HttpComponentsUtil.addParameter((String)"search", (String)"q", (String)StringBundler.concat((String[])new String[]{"FIND {", search, "} IN ALL FIELDS RETURNING ", objectDefinition.getExternalReferenceCode(), "(FIELDS(ALL)", predicateString, this._getSorts(objectDefinition.getObjectDefinitionId(), sorts), this._getSalesforcePagination(pagination), ")"}));
        }
        return HttpComponentsUtil.addParameter((String)"query", (String)"q", (String)StringBundler.concat((String[])new String[]{"SELECT FIELDS(ALL) FROM ", objectDefinition.getExternalReferenceCode(), predicateString, this._getSorts(objectDefinition.getObjectDefinitionId(), sorts), this._getSalesforcePagination(pagination)}));
    }

    private Page<ObjectEntry> _getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, DTOConverterContext dtoConverterContext, Pagination pagination, String search, Sort[] sorts) throws Exception {
        JSONObject responseJSONObject = this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, pagination, this._getAccountRestrictionPredicateString(companyId, dtoConverterContext, objectDefinition, scopeKey), search, sorts));
        if (responseJSONObject == null || responseJSONObject.length() == 0) {
            return Page.of(Collections.emptyList());
        }
        JSONArray jsonArray = Validator.isNotNull((String)search) ? responseJSONObject.getJSONArray("searchRecords") : responseJSONObject.getJSONArray("records");
        return Page.of(this._toObjectEntries(companyId, dtoConverterContext, jsonArray, objectDefinition), (Pagination)pagination, (long)this._getTotalCount(companyId, objectDefinition, this._getAccountRestrictionPredicateString(companyId, dtoConverterContext, objectDefinition, scopeKey), scopeKey, search));
    }

    private ObjectField _getObjectFieldByExternalReferenceCode(String externalReferenceCode, List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (!Objects.equals(externalReferenceCode, objectField.getExternalReferenceCode())) continue;
            return objectField;
        }
        return null;
    }

    private ObjectField _getObjectFieldByName(String name, List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (!Objects.equals(name, objectField.getName())) continue;
            return objectField;
        }
        return null;
    }

    private String _getSalesforcePagination(Pagination pagination) {
        return StringBundler.concat((Object[])new Object[]{" LIMIT ", pagination.getPageSize(), " OFFSET ", pagination.getStartPosition()});
    }

    private String _getSorts(long objectDefinitionId, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return "";
        }
        StringBundler sb = new StringBundler();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinitionId);
        for (Sort sort : sorts) {
            String fieldName = sort.getFieldName();
            if (fieldName.startsWith("nestedFieldArray.")) {
                String[] parts = StringUtil.split((String)sort.getFieldName(), (String)"#");
                fieldName = parts[1];
            }
            if (Objects.equals(fieldName, "status")) continue;
            if (sb.length() == 0) {
                sb.append(" ORDER BY ");
            } else {
                sb.append(", ");
            }
            String defaultFieldName = this._defaultObjectFieldNames.get(fieldName);
            if (defaultFieldName != null) {
                sb.append(defaultFieldName);
            } else {
                ObjectField objectField = this._getObjectFieldByName(fieldName, objectFields);
                if (objectField == null) continue;
                sb.append(objectField.getExternalReferenceCode());
            }
            if (!sort.isReverse()) continue;
            sb.append(" DESC");
        }
        return sb.toString();
    }

    private int _getTotalCount(long companyId, ObjectDefinition objectDefinition, String predicateString, String scopeKey, String search) {
        if (Validator.isNotNull((String)search)) {
            JSONObject responseJSONObject = this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), this._getLocation(objectDefinition, Pagination.of((int)1, (int)200), predicateString, search, null));
            JSONArray jsonArray = responseJSONObject.getJSONArray("searchRecords");
            return jsonArray.length();
        }
        JSONObject responseJSONObject = this._salesforceHttp.get(companyId, this.getGroupId(objectDefinition, scopeKey), HttpComponentsUtil.addParameter((String)"query", (String)"q", (String)StringBundler.concat((String[])new String[]{"SELECT COUNT(Id) FROM ", objectDefinition.getExternalReferenceCode(), predicateString})));
        JSONArray jsonArray = responseJSONObject.getJSONArray("records");
        return jsonArray.getJSONObject(0).getInt("expr0");
    }

    private JSONObject _toJSONObject(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        Map properties = objectEntry.getProperties();
        for (String key : properties.keySet()) {
            ObjectField objectField = this._getObjectFieldByName(key, objectFields);
            if (objectField == null) continue;
            ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(objectField.getBusinessType());
            Object value = objectFieldBusinessType.getValue(objectField, dtoConverterContext.getUserId(), properties);
            if (objectField.compareBusinessType("MultiselectPicklist")) {
                StringBundler sb = new StringBundler();
                List listTypeEntryKeys = null;
                listTypeEntryKeys = value instanceof List ? (List)value : ListUtil.fromString((String)GetterUtil.getString((Object)value), (String)", ");
                for (String listTypeEntryKey : listTypeEntryKeys) {
                    String listTypeEntryExternalReferenceCode = this._getListTypeEntryExternalReferenceCode(objectField.getListTypeDefinitionId(), listTypeEntryKey);
                    if (Validator.isNull((String)listTypeEntryExternalReferenceCode)) continue;
                    sb.append(listTypeEntryExternalReferenceCode);
                    sb.append(";");
                }
                if (sb.index() > 1) {
                    sb.setIndex(sb.index() - 1);
                }
                value = sb.toString();
            } else if (objectField.compareBusinessType("Picklist")) {
                String listTypeEntryKey = GetterUtil.getString((Object)value);
                if (value instanceof Map) {
                    HashMap valueMap = (HashMap)value;
                    listTypeEntryKey = (String)valueMap.get("key");
                }
                value = this._getListTypeEntryExternalReferenceCode(objectField.getListTypeDefinitionId(), listTypeEntryKey);
            }
            map.put(objectField.getExternalReferenceCode(), Objects.equals(value, "") ? null : value);
            if (!StringUtil.endsWith((String)objectDefinition.getExternalReferenceCode(), (String)_CUSTOM_OBJECT_SUFFIX) || !Objects.equals(objectField.getObjectFieldId(), objectDefinition.getTitleObjectFieldId())) continue;
            map.put("Name", value);
        }
        return this._jsonFactory.createJSONObject(this._jsonFactory.looseSerialize(map));
    }

    private List<ObjectEntry> _toObjectEntries(long companyId, DTOConverterContext dtoConverterContext, JSONArray jsonArray, ObjectDefinition objectDefinition) throws Exception {
        DateFormat dateFormat = this._getDateFormat();
        return JSONUtil.toList((JSONArray)jsonArray, jsonObject -> this._toObjectEntry(companyId, dateFormat, dtoConverterContext, (JSONObject)jsonObject, objectDefinition));
    }

    private ObjectEntry _toObjectEntry(final long companyId, final DateFormat dateFormat, final DTOConverterContext dtoConverterContext, final JSONObject jsonObject, final ObjectDefinition objectDefinition) throws Exception {
        return new ObjectEntry(){
            {
                this.actions = HashMapBuilder.put((Object)"delete", (Object)SalesforceObjectEntryManagerImpl.this.addDeleteAction(objectDefinition, this.scopeKey, dtoConverterContext.getUser())).build();
                this.creator = CreatorUtil.toCreator((Portal)SalesforceObjectEntryManagerImpl.this._portal, null, (User)SalesforceObjectEntryManagerImpl.this._userLocalService.fetchUserByExternalReferenceCode(jsonObject.getString("OwnerId"), companyId));
                this.dateCreated = dateFormat.parse(jsonObject.getString("CreatedDate"));
                this.dateModified = dateFormat.parse(jsonObject.getString("LastModifiedDate"));
                this.externalReferenceCode = jsonObject.getString("Id");
                this.properties = SalesforceObjectEntryManagerImpl.this._toProperties(dtoConverterContext, jsonObject, objectDefinition, SalesforceObjectEntryManagerImpl.this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId()));
                this.status = new Status(){
                    {
                        this.code = 0;
                        this.label = "approved";
                        this.label_i18n = "Approved";
                    }
                };
            }
        };
    }

    private Map<String, Object> _toProperties(DTOConverterContext dtoConverterContext, JSONObject jsonObject, ObjectDefinition objectDefinition, List<ObjectField> objectFields) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : jsonObject.keySet()) {
            ObjectField objectField = this._getObjectFieldByExternalReferenceCode(key, objectFields);
            if (objectField == null) continue;
            if (jsonObject.isNull(key)) {
                properties.put(objectField.getName(), null);
                continue;
            }
            Object value = jsonObject.get(key);
            if (objectField.compareBusinessType("DateTime")) {
                String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
                if (StringUtil.equals((String)ObjectFieldSettingUtil.getValue((String)"timeStorage", (ObjectField)objectField), (String)"convertToUTC")) {
                    pattern = pattern + "Z";
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                value = simpleDateFormat.format(simpleDateFormat.parse(GetterUtil.getString((Object)value)));
            } else if (objectField.compareBusinessType("Integer") || objectField.compareBusinessType("LongInteger")) {
                if (value instanceof BigDecimal) {
                    BigDecimal bigDecimalValue = (BigDecimal)value;
                    value = bigDecimalValue.toBigInteger();
                }
            } else if (objectField.compareBusinessType("MultiselectPicklist")) {
                value = TransformUtil.transformToList((Object[])StringUtil.split((String)GetterUtil.getString((Object)value), (String)";"), listTypeEntryExternalReferenceCode -> this._getListEntry(dtoConverterContext, (String)listTypeEntryExternalReferenceCode, objectDefinition, objectField));
            } else if (objectField.compareBusinessType("Picklist")) {
                value = this._getListEntry(dtoConverterContext, GetterUtil.getString((Object)value), objectDefinition, objectField);
            }
            properties.put(objectField.getName(), value);
        }
        return properties;
    }
}

