/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.validation.rule;

import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.object.validation.rule.ObjectValidationRuleEngineTracker;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import java.util.ArrayList;
import java.util.List;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Marco Leo
 */
@Component(immediate = true, service = ObjectValidationRuleEngineTracker.class)
public class ObjectValidationRuleEngineTrackerImpl
	implements ObjectValidationRuleEngineTracker {

	@Override
	public ObjectValidationRuleEngine getObjectValidationRuleEngine(
		String key) {

		return _serviceTrackerMap.getService(key);
	}

	@Override
	public List<ObjectValidationRuleEngine> getObjectValidationRuleEngines() {
		return new ArrayList(_serviceTrackerMap.values());
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, ObjectValidationRuleEngine.class, null,
			new ServiceReferenceMapper<String, ObjectValidationRuleEngine>() {

				@Override
				public void map(
					ServiceReference<ObjectValidationRuleEngine>
						serviceReference,
					Emitter<String> emitter) {

					ObjectValidationRuleEngine objectValidationRuleEngine =
						bundleContext.getService(serviceReference);

					emitter.emit(objectValidationRuleEngine.getName());
				}

			});
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private ServiceTrackerMap<String, ObjectValidationRuleEngine>
		_serviceTrackerMap;

}