/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.notification.type;

import com.liferay.notification.type.NotificationType;
import com.liferay.object.model.ObjectDefinition;

import java.util.Locale;
import java.util.Map;

/**
 * @author Gustavo Lima
 */
public class ObjectDefinitionNotificationType implements NotificationType {

	public ObjectDefinitionNotificationType(ObjectDefinition objectDefinition) {
		_objectDefinition = objectDefinition;
	}

	@Override
	public String getClassName(Object object) {
		return _objectDefinition.getClassName();
	}

	@Override
	public long getClassPK(Object object) {
		if (!(object instanceof Map)) {
			throw new IllegalArgumentException(
				"Object " + object + " is not a map");
		}

		Map<String, Object> values = (Map<String, Object>)object;

		return (Long)values.get("objectEntryId");
	}

	@Override
	public String getKey() {
		return _objectDefinition.getClassName();
	}

	@Override
	public String getLabel(Locale locale) {
		return _objectDefinition.getShortName();
	}

	private final ObjectDefinition _objectDefinition;

}