/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.field.setting.contributor;

import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.exception.PortalException;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Feliphe Marinho
 */
@Component(
	immediate = true, property = "object.field.setting.type.key=default",
	service = ObjectFieldSettingContributor.class
)
public class DefaultObjectFieldSettingContributor
	implements ObjectFieldSettingContributor {

	@Override
	public void addObjectFieldSetting(
			long userId, long objectFieldId,
			ObjectFieldSetting objectFieldSetting)
		throws PortalException {

		_objectFieldSettingLocalService.addObjectFieldSetting(
			userId, objectFieldId, objectFieldSetting.getName(),
			objectFieldSetting.getValue());
	}

	@Override
	public void updateObjectFieldSetting(
			long objectFieldSettingId, ObjectFieldSetting objectFieldSetting)
		throws PortalException {

		_objectFieldSettingLocalService.updateObjectFieldSetting(
			objectFieldSettingId, objectFieldSetting.getValue());
	}

	@Reference
	private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

}