/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.DefaultObjectViewException;
import com.liferay.object.exception.ObjectViewColumnFieldNameException;
import com.liferay.object.exception.ObjectViewFilterColumnException;
import com.liferay.object.exception.ObjectViewSortColumnException;
import com.liferay.object.field.filter.parser.ObjectFieldFilterParser;
import com.liferay.object.field.filter.parser.ObjectFieldFilterParserServicesTracker;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectView;
import com.liferay.object.model.ObjectViewColumn;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.model.ObjectViewSortColumn;
import com.liferay.object.service.base.ObjectViewLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectViewColumnPersistence;
import com.liferay.object.service.persistence.ObjectViewFilterColumnPersistence;
import com.liferay.object.service.persistence.ObjectViewSortColumnPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectView"}, service={AopService.class})
public class ObjectViewLocalServiceImpl
extends ObjectViewLocalServiceBaseImpl {
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldFilterParserServicesTracker _objectFieldFilterParserServicesTracker;
    private final Set<String> _objectFieldNames = Collections.unmodifiableSet(SetUtil.fromArray((Object[])new String[]{"creator", "dateCreated", "dateModified", "id", "status"}));
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectViewColumnPersistence _objectViewColumnPersistence;
    @Reference
    private ObjectViewFilterColumnPersistence _objectViewFilterColumnPersistence;
    @Reference
    private ObjectViewSortColumnPersistence _objectViewSortColumnPersistence;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectView addObjectView(long userId, long objectDefinitionId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns, List<ObjectViewFilterColumn> objectViewFilterColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (defaultObjectView) {
            this._validateDefaultObjectView(0L, objectDefinitionId);
        }
        ObjectView objectView = this.objectViewPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectView.setCompanyId(user.getCompanyId());
        objectView.setUserId(user.getUserId());
        objectView.setUserName(user.getFullName());
        objectView.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectView.setDefaultObjectView(defaultObjectView);
        objectView.setNameMap(nameMap);
        objectView = (ObjectView)this.objectViewPersistence.update((BaseModel)objectView);
        objectView.setObjectViewColumns(this._addObjectViewColumns(user, objectView.getObjectViewId(), objectViewColumns));
        objectView.setObjectViewFilterColumns(this._addObjectViewFilterColumns(user, objectView, objectViewFilterColumns));
        objectView.setObjectViewSortColumns(this._addObjectViewSortColumns(user, objectView.getObjectViewId(), objectViewColumns, objectViewSortColumns));
        return objectView;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectView deleteObjectView(long objectViewId) throws PortalException {
        return this.deleteObjectView(this.objectViewPersistence.findByPrimaryKey(objectViewId));
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectView deleteObjectView(ObjectView objectView) {
        objectView = (ObjectView)this.objectViewPersistence.remove((BaseModel)objectView);
        this._objectViewColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        this._objectViewFilterColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        this._objectViewSortColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        return objectView;
    }

    public void deleteObjectViews(long objectDefinitionId) throws PortalException {
        for (ObjectView objectView : this.objectViewPersistence.findByObjectDefinitionId(objectDefinitionId)) {
            this.objectViewLocalService.deleteObjectView(objectView);
        }
    }

    public ObjectView fetchDefaultObjectView(long objectDefinitionId) {
        ObjectView objectView = this.objectViewPersistence.fetchByODI_DOV_First(objectDefinitionId, true, null);
        if (objectView != null) {
            objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
            objectView.setObjectViewFilterColumns(this._objectViewFilterColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
            objectView.setObjectViewSortColumns(this._objectViewSortColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        }
        return objectView;
    }

    @Override
    public ObjectView getObjectView(long objectViewId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        objectView.setObjectViewFilterColumns(this._objectViewFilterColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        objectView.setObjectViewSortColumns(this._objectViewSortColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        return objectView;
    }

    public List<ObjectView> getObjectViews(long objectDefinitionId) {
        List objectViews = this.objectViewPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectView objectView : objectViews) {
            objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
            objectView.setObjectViewFilterColumns(this._objectViewFilterColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
            objectView.setObjectViewSortColumns(this._objectViewSortColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        }
        return objectViews;
    }

    public void unassociateObjectField(ObjectField objectField) {
        List objectViews = this.objectViewPersistence.findByObjectDefinitionId(objectField.getObjectDefinitionId());
        for (ObjectView objectView : objectViews) {
            this._objectViewColumnPersistence.removeByOVI_OFN(objectView.getObjectViewId(), objectField.getName());
            this._objectViewFilterColumnPersistence.removeByOVI_OFN(objectView.getObjectViewId(), objectField.getName());
            this._objectViewSortColumnPersistence.removeByOVI_OFN(objectView.getObjectViewId(), objectField.getName());
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectView updateObjectView(long objectViewId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns, List<ObjectViewFilterColumn> objectViewFilterColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        if (defaultObjectView) {
            this._validateDefaultObjectView(objectViewId, objectView.getObjectDefinitionId());
        }
        this._objectViewColumnPersistence.removeByObjectViewId(objectViewId);
        this._objectViewFilterColumnPersistence.removeByObjectViewId(objectViewId);
        this._objectViewSortColumnPersistence.removeByObjectViewId(objectViewId);
        objectView.setDefaultObjectView(defaultObjectView);
        objectView.setNameMap(nameMap);
        objectView = (ObjectView)this.objectViewPersistence.update((BaseModel)objectView);
        User user = this._userLocalService.getUser(objectView.getUserId());
        objectView.setObjectViewColumns(this._addObjectViewColumns(user, objectViewId, objectViewColumns));
        objectView.setObjectViewFilterColumns(this._addObjectViewFilterColumns(user, objectView, objectViewFilterColumns));
        objectView.setObjectViewSortColumns(this._addObjectViewSortColumns(user, objectView.getObjectViewId(), objectViewColumns, objectViewSortColumns));
        return objectView;
    }

    private List<ObjectViewColumn> _addObjectViewColumns(User user, long objectViewId, List<ObjectViewColumn> objectViewColumns) throws PortalException {
        try {
            this._validateObjectViewColumns(objectViewId, objectViewColumns);
        }
        catch (ObjectViewColumnFieldNameException objectViewColumnFieldNameException) {
            throw new ObjectViewColumnFieldNameException(objectViewColumnFieldNameException.getMessage());
        }
        return TransformUtil.transform(objectViewColumns, objectViewColumn -> {
            ObjectViewColumn newObjectViewColumn = this._objectViewColumnPersistence.create(this.counterLocalService.increment());
            newObjectViewColumn.setCompanyId(user.getCompanyId());
            newObjectViewColumn.setUserId(user.getUserId());
            newObjectViewColumn.setUserName(user.getFullName());
            newObjectViewColumn.setObjectViewId(objectViewId);
            newObjectViewColumn.setLabelMap(objectViewColumn.getLabelMap());
            newObjectViewColumn.setObjectFieldName(objectViewColumn.getObjectFieldName());
            newObjectViewColumn.setPriority(objectViewColumn.getPriority());
            return (ObjectViewColumn)this._objectViewColumnPersistence.update((BaseModel)newObjectViewColumn);
        });
    }

    private List<ObjectViewFilterColumn> _addObjectViewFilterColumns(User user, ObjectView objectView, List<ObjectViewFilterColumn> objectViewFilterColumns) throws PortalException {
        this._validateObjectViewFilterColumns(objectView.getObjectDefinitionId(), objectViewFilterColumns);
        return TransformUtil.transform(objectViewFilterColumns, objectViewFilterColumn -> {
            ObjectViewFilterColumn newObjectViewFilterColumn = this._objectViewFilterColumnPersistence.create(this.counterLocalService.increment());
            newObjectViewFilterColumn.setCompanyId(user.getCompanyId());
            newObjectViewFilterColumn.setUserId(user.getUserId());
            newObjectViewFilterColumn.setUserName(user.getFullName());
            newObjectViewFilterColumn.setObjectViewId(objectView.getObjectViewId());
            newObjectViewFilterColumn.setFilterType(objectViewFilterColumn.getFilterType());
            newObjectViewFilterColumn.setJson(objectViewFilterColumn.getJson());
            newObjectViewFilterColumn.setObjectFieldName(objectViewFilterColumn.getObjectFieldName());
            return (ObjectViewFilterColumn)this._objectViewFilterColumnPersistence.update((BaseModel)newObjectViewFilterColumn);
        });
    }

    private List<ObjectViewSortColumn> _addObjectViewSortColumns(User user, long objectViewId, List<ObjectViewColumn> objectViewColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        try {
            this._validateObjectViewSortColumns(objectViewColumns, objectViewSortColumns);
        }
        catch (ObjectViewSortColumnException objectViewSortColumnException) {
            throw new ObjectViewSortColumnException(objectViewSortColumnException.getMessage());
        }
        return TransformUtil.transform(objectViewSortColumns, objectViewSortColumn -> {
            ObjectViewSortColumn newObjectViewSortColumn = this._objectViewSortColumnPersistence.create(this.counterLocalService.increment());
            newObjectViewSortColumn.setCompanyId(user.getCompanyId());
            newObjectViewSortColumn.setUserId(user.getUserId());
            newObjectViewSortColumn.setUserName(user.getFullName());
            newObjectViewSortColumn.setObjectViewId(objectViewId);
            newObjectViewSortColumn.setObjectFieldName(objectViewSortColumn.getObjectFieldName());
            newObjectViewSortColumn.setPriority(objectViewSortColumn.getPriority());
            newObjectViewSortColumn.setSortOrder(objectViewSortColumn.getSortOrder());
            return (ObjectViewSortColumn)this._objectViewSortColumnPersistence.update((BaseModel)newObjectViewSortColumn);
        });
    }

    private void _validateDefaultObjectView(long objectViewId, long objectDefinitionId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.fetchByODI_DOV_First(objectDefinitionId, true, null);
        if (objectView != null && objectView.getObjectViewId() != objectViewId) {
            throw new DefaultObjectViewException("There can only be one default object view");
        }
    }

    private void _validateObjectViewColumns(long objectViewId, List<ObjectViewColumn> objectViewColumns) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        List objectFields = this._objectFieldPersistence.findByObjectDefinitionId(objectView.getObjectDefinitionId());
        HashSet<String> objectFieldNames = new HashSet<String>(this._objectFieldNames);
        objectFields.forEach(objectField -> objectFieldNames.add(objectField.getName()));
        LinkedHashSet<String> objectViewColumnFieldNames = new LinkedHashSet<String>();
        for (ObjectViewColumn objectViewColumn : objectViewColumns) {
            if (!objectFieldNames.contains(objectViewColumn.getObjectFieldName())) {
                throw new ObjectViewColumnFieldNameException("There is no object field with the name: " + objectViewColumn.getObjectFieldName());
            }
            if (objectViewColumnFieldNames.contains(objectViewColumn.getObjectFieldName())) {
                throw new ObjectViewColumnFieldNameException("There is already an object view column with the object field name: " + objectViewColumn.getObjectFieldName());
            }
            objectViewColumnFieldNames.add(objectViewColumn.getObjectFieldName());
        }
    }

    private void _validateObjectViewFilterColumns(long objectDefinitionId, List<ObjectViewFilterColumn> objectViewFilterColumns) throws PortalException {
        for (ObjectViewFilterColumn objectViewFilterColumn : objectViewFilterColumns) {
            if (Validator.isNull((String)objectViewFilterColumn.getObjectFieldName())) {
                throw new ObjectViewFilterColumnException("Object field name is null");
            }
            long listTypeDefinitionId = 0L;
            if (this._objectFieldNames.contains(objectViewFilterColumn.getObjectFieldName())) {
                if (Objects.equals(objectViewFilterColumn.getObjectFieldName(), "creator") || Objects.equals(objectViewFilterColumn.getObjectFieldName(), "id")) {
                    throw new ObjectViewFilterColumnException(StringBundler.concat((String[])new String[]{"Object field name \"", objectViewFilterColumn.getObjectFieldName(), "\" is not filterable"}));
                }
            } else {
                ObjectField objectField = this._objectFieldPersistence.findByODI_N(objectDefinitionId, objectViewFilterColumn.getObjectFieldName());
                if (!Objects.equals(objectField.getBusinessType(), "Picklist")) {
                    throw new ObjectViewFilterColumnException(StringBundler.concat((String[])new String[]{"Object field name \"", objectViewFilterColumn.getObjectFieldName(), "\" is not filterable"}));
                }
                listTypeDefinitionId = objectField.getObjectDefinitionId();
            }
            if (Validator.isNull((String)objectViewFilterColumn.getFilterType()) && Validator.isNull((String)objectViewFilterColumn.getJson())) continue;
            if (Validator.isNull((String)objectViewFilterColumn.getFilterType()) && Validator.isNotNull((String)objectViewFilterColumn.getJson()) || Validator.isNotNull((String)objectViewFilterColumn.getFilterType()) && Validator.isNull((String)objectViewFilterColumn.getJson())) {
                throw new ObjectViewFilterColumnException(StringBundler.concat((String[])new String[]{"Object field name \"", objectViewFilterColumn.getObjectFieldName(), "\" needs to have the filter type and JSON specified"}));
            }
            ObjectFieldFilterParser objectFieldFilterParser = this._objectFieldFilterParserServicesTracker.getObjectFieldFilterParser(objectViewFilterColumn.getFilterType());
            objectFieldFilterParser.validate(listTypeDefinitionId, objectViewFilterColumn);
        }
    }

    private void _validateObjectViewSortColumns(List<ObjectViewColumn> objectViewColumns, List<ObjectViewSortColumn> objectViewSortColumns) throws PortalException {
        LinkedHashSet<String> objectFieldNames = new LinkedHashSet<String>();
        for (ObjectViewColumn objectViewColumn : objectViewColumns) {
            objectFieldNames.add(objectViewColumn.getObjectFieldName());
        }
        for (ObjectViewSortColumn objectViewSortColumn : objectViewSortColumns) {
            if (!objectFieldNames.contains(objectViewSortColumn.getObjectFieldName())) {
                throw new ObjectViewSortColumnException("There is no object view column with the name: " + objectViewSortColumn.getObjectFieldName());
            }
            if (StringUtil.equals((String)objectViewSortColumn.getSortOrder(), (String)"asc") || StringUtil.equals((String)objectViewSortColumn.getSortOrder(), (String)"desc")) continue;
            throw new ObjectViewSortColumnException("There is no sort order of type: " + objectViewSortColumn.getSortOrder());
        }
    }
}

