/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.notification.term.contributor;

import com.liferay.notification.term.contributor.NotificationTermContributor;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.notification.term.util.ObjectDefinitionNotificationTermUtil;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ObjectDefinitionNotificationTermContributor
implements NotificationTermContributor {
    private final Map<String, Long> _objectFieldIds = HashMapBuilder.put((Object)"[%OBJECT_ENTRY_CREATOR%]", (Object)0L).build();
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final UserLocalService _userLocalService;

    public ObjectDefinitionNotificationTermContributor(ObjectDefinition objectDefinition, ObjectFieldLocalService objectFieldLocalService, UserLocalService userLocalService) {
        this._objectFieldLocalService = objectFieldLocalService;
        this._userLocalService = userLocalService;
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        for (ObjectField objectField : objectFields) {
            this._objectFieldIds.put(ObjectDefinitionNotificationTermUtil.getObjectFieldTermName((String)objectDefinition.getShortName(), (String)objectField.getName()), objectField.getObjectFieldId());
        }
    }

    public List<String> getTermNames() {
        return new ArrayList<String>(this._objectFieldIds.keySet());
    }

    public String getTermValue(Locale locale, Object object, String termName) throws PortalException {
        if (!(object instanceof Map)) {
            return termName;
        }
        Map termValues = (Map)object;
        if (termName.equals("[%OBJECT_ENTRY_CREATOR%]")) {
            User user = this._userLocalService.getUser(((Long)termValues.get("currentUserId")).longValue());
            return user.getFullName(true, true);
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(this._objectFieldIds.get(termName).longValue());
        if (objectField == null) {
            return termName;
        }
        return String.valueOf(termValues.get(objectField.getName()));
    }

    public String getTermValue(String termName, Locale locale) {
        if (termName.equals("[%OBJECT_ENTRY_CREATOR%]")) {
            return LanguageUtil.get((Locale)locale, (String)"creator");
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(this._objectFieldIds.get(termName).longValue());
        return objectField.getLabel(locale);
    }
}

