/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectViewColumn;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectViewColumnModelListener
extends BaseModelListener<ObjectViewColumn> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectViewColumn objectViewColumn) throws ModelListenerException {
        this._route("ADD", objectViewColumn);
    }

    public void onBeforeRemove(ObjectViewColumn objectViewColumn) throws ModelListenerException {
        this._route("DELETE", objectViewColumn);
    }

    public void onBeforeUpdate(ObjectViewColumn originalObjectViewColumn, ObjectViewColumn objectViewColumn) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectViewColumn.class.getName(), (long)objectViewColumn.getObjectViewColumnId(), this._getModifiedAttributes(originalObjectViewColumn, objectViewColumn)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectViewColumn originalObjectViewColumn, ObjectViewColumn objectViewColumn) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectViewColumn, (Object)originalObjectViewColumn);
        attributesBuilder.add("labelMap");
        attributesBuilder.add("objectFieldName");
        attributesBuilder.add("priority");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectViewColumn objectViewColumn) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectViewColumn.class.getName(), (long)objectViewColumn.getObjectViewColumnId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("labelMap", (Object)objectViewColumn.getLabelMap()).put("objectFieldName", objectViewColumn.getObjectFieldName()).put("priority", objectViewColumn.getPriority());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

