/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectLayoutRow;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectLayoutRowModelListener
extends BaseModelListener<ObjectLayoutRow> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectLayoutRow objectLayoutRow) throws ModelListenerException {
        this._route("ADD", objectLayoutRow);
    }

    public void onBeforeRemove(ObjectLayoutRow objectLayoutRow) throws ModelListenerException {
        this._route("DELETE", objectLayoutRow);
    }

    public void onBeforeUpdate(ObjectLayoutRow originalObjectLayoutRow, ObjectLayoutRow objectLayoutRow) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectLayoutRow.class.getName(), (long)objectLayoutRow.getObjectLayoutRowId(), this._getModifiedAttributes(originalObjectLayoutRow, objectLayoutRow)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectLayoutRow originalObjectLayoutRow, ObjectLayoutRow objectLayoutRow) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectLayoutRow, (Object)originalObjectLayoutRow);
        attributesBuilder.add("objectLayoutBoxId");
        attributesBuilder.add("priority");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectLayoutRow objectLayoutRow) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectLayoutRow.class.getName(), (long)objectLayoutRow.getObjectLayoutRowId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("objectLayoutBoxId", objectLayoutRow.getObjectLayoutBoxId()).put("priority", objectLayoutRow.getPriority());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

