/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectLayout;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectLayoutModelListener
extends BaseModelListener<ObjectLayout> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectLayout objectLayout) throws ModelListenerException {
        this._route("ADD", objectLayout);
    }

    public void onBeforeRemove(ObjectLayout objectLayout) throws ModelListenerException {
        this._route("DELETE", objectLayout);
    }

    public void onBeforeUpdate(ObjectLayout originalObjectLayout, ObjectLayout objectLayout) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectLayout.class.getName(), (long)objectLayout.getObjectLayoutId(), this._getModifiedAttributes(originalObjectLayout, objectLayout)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectLayout originalObjectLayout, ObjectLayout objectLayout) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectLayout, (Object)originalObjectLayout);
        attributesBuilder.add("defaultObjectLayout");
        attributesBuilder.add("nameMap");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectLayout objectLayout) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectLayout.class.getName(), (long)objectLayout.getObjectLayoutId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("defaultObjectLayout", objectLayout.isDefaultObjectLayout()).put("nameMap", (Object)objectLayout.getNameMap());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

