/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectLayoutColumn;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectLayoutColumnModelListener
extends BaseModelListener<ObjectLayoutColumn> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectLayoutColumn objectLayoutColumn) throws ModelListenerException {
        this._route("ADD", objectLayoutColumn);
    }

    public void onBeforeRemove(ObjectLayoutColumn objectLayoutColumn) throws ModelListenerException {
        this._route("DELETE", objectLayoutColumn);
    }

    public void onBeforeUpdate(ObjectLayoutColumn originalObjectLayoutColumn, ObjectLayoutColumn objectLayoutColumn) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectLayoutColumn.class.getName(), (long)objectLayoutColumn.getObjectLayoutColumnId(), this._getModifiedAttributes(originalObjectLayoutColumn, objectLayoutColumn)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectLayoutColumn originalObjectLayoutColumn, ObjectLayoutColumn objectLayoutColumn) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectLayoutColumn, (Object)originalObjectLayoutColumn);
        attributesBuilder.add("objectFieldId");
        attributesBuilder.add("objectLayoutRowId");
        attributesBuilder.add("priority");
        attributesBuilder.add("size");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectLayoutColumn objectLayoutColumn) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectLayoutColumn.class.getName(), (long)objectLayoutColumn.getObjectLayoutColumnId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("objectFieldId", objectLayoutColumn.getObjectFieldId()).put("objectLayoutRowId", objectLayoutColumn.getObjectLayoutRowId()).put("priority", objectLayoutColumn.getPriority()).put("size", objectLayoutColumn.getSize());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

