/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.filter.parser;

import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.exception.ObjectViewFilterColumnException;
import com.liferay.object.field.filter.parser.ObjectFieldFilterParser;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.field.filter.type.key=excludes", "object.field.filter.type.key=includes"}, service={ObjectFieldFilterParser.class})
public class ListObjectFieldFilterParser
implements ObjectFieldFilterParser {
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;

    public Map<String, Object> parse(long listTypeDefinitionId, Locale locale, ObjectViewFilterColumn objectViewFilterColumn) throws PortalException {
        return HashMapBuilder.put((Object)"exclude", (Object)"excludes".equals(objectViewFilterColumn.getFilterType())).put((Object)"itemsValues", () -> {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)objectViewFilterColumn.getJson());
            JSONArray jsonArray = jsonObject.getJSONArray(objectViewFilterColumn.getFilterType());
            if (Objects.equals(objectViewFilterColumn.getObjectFieldName(), "status")) {
                return this._toIntegerList(jsonArray);
            }
            ArrayList<HashMap> map = new ArrayList<HashMap>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(listTypeDefinitionId, jsonArray.getString(i));
                map.add(HashMapBuilder.put((Object)"label", (Object)listTypeEntry.getName(locale)).put((Object)"value", (Object)jsonArray.getString(i)).build());
            }
            return map;
        }).build();
    }

    public void validate(long listTypeDefinitionId, ObjectViewFilterColumn objectViewFilterColumn) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)objectViewFilterColumn.getJson());
        JSONArray jsonArray = jsonObject.getJSONArray(objectViewFilterColumn.getFilterType());
        if (jsonArray == null) {
            throw new ObjectViewFilterColumnException("JSON array is null for filter type " + objectViewFilterColumn.getFilterType());
        }
        if (Objects.equals(objectViewFilterColumn.getObjectFieldName(), "status")) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    this._toIntegerList(jsonArray);
                    continue;
                }
                catch (Exception exception) {
                    throw new ObjectViewFilterColumnException("JSON array is invalid for filter type " + objectViewFilterColumn.getFilterType(), (Throwable)exception);
                }
            }
        }
    }

    private List<Integer> _toIntegerList(JSONArray jsonArray) {
        ArrayList<Integer> statuses = new ArrayList<Integer>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            statuses.add((Integer)jsonArray.get(i));
        }
        return statuses;
    }
}

