/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFieldSettingModel;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.field.business.type.key=Aggregation"}, service={AggregationObjectFieldBusinessType.class, ObjectFieldBusinessType.class})
public class AggregationObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"function", "relationship", "summarizeField"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDescription(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"summarize-data-values");
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"aggregation");
    }

    public String getName() {
        return "Aggregation";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        HashMap properties = HashMapBuilder.put((Object)"readOnly", (Object)true).build();
        ListUtil.isNotEmptyForEach((List)this._objectFieldSettingLocalService.getObjectFieldSettings(objectField.getObjectFieldId()), objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return properties;
    }

    public Set<String> getRequiredObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"function", "relationship", "summarizeField"});
    }

    public void validateObjectFieldSettings(String objectFieldName, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        HashSet<String> missingRequiredObjectFieldSettingsNames = new HashSet<String>();
        Stream stream = objectFieldSettings.stream();
        Map<String, String> objectFieldSettingsValuesMap = stream.collect(Collectors.toMap(ObjectFieldSettingModel::getName, ObjectFieldSettingModel::getValue));
        Set<String> requiredObjectFieldSettingsNames = this.getRequiredObjectFieldSettingsNames();
        if (Objects.equals(GetterUtil.getString((String)objectFieldSettingsValuesMap.get("function")), "COUNT")) {
            requiredObjectFieldSettingsNames.remove("summarizeField");
        }
        for (String requiredObjectFieldSettingName : requiredObjectFieldSettingsNames) {
            if (!Validator.isNull((String)objectFieldSettingsValuesMap.get(requiredObjectFieldSettingName))) continue;
            missingRequiredObjectFieldSettingsNames.add(requiredObjectFieldSettingName);
        }
        if (!missingRequiredObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingValueException.MissingRequiredValues(objectFieldName, missingRequiredObjectFieldSettingsNames);
        }
        HashSet<String> notAllowedObjectFieldSettingsNames = new HashSet<String>(objectFieldSettingsValuesMap.keySet());
        notAllowedObjectFieldSettingsNames.removeAll(this.getAllowedObjectFieldSettingsNames());
        notAllowedObjectFieldSettingsNames.removeAll(requiredObjectFieldSettingsNames);
        if (!notAllowedObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingNameException.NotAllowedNames(objectFieldName, notAllowedObjectFieldSettingsNames);
        }
    }
}

