/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectLayoutBox;
import com.liferay.object.model.ObjectLayoutBoxModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectLayoutBox service. Represents a row in the &quot;ObjectLayoutBox&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectLayoutBoxModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectLayoutBoxImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectLayoutBoxImpl
 * @generated
 */
public class ObjectLayoutBoxModelImpl
	extends BaseModelImpl<ObjectLayoutBox> implements ObjectLayoutBoxModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object layout box model instance should use the <code>ObjectLayoutBox</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectLayoutBox";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectLayoutBoxId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectLayoutTabId", Types.BIGINT}, {"collapsable", Types.BOOLEAN},
		{"name", Types.VARCHAR}, {"priority", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectLayoutBoxId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectLayoutTabId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("collapsable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectLayoutBox (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectLayoutBoxId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectLayoutTabId LONG,collapsable BOOLEAN,name STRING null,priority INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table ObjectLayoutBox";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectLayoutBox.objectLayoutBoxId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectLayoutBox.objectLayoutBoxId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTLAYOUTTABID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTLAYOUTBOXID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectLayoutBoxModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectLayoutBoxId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectLayoutBoxId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectLayoutBoxId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectLayoutBox.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectLayoutBox.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectLayoutBox, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectLayoutBox, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectLayoutBox, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectLayoutBox)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectLayoutBox, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectLayoutBox, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectLayoutBox)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectLayoutBox, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectLayoutBox, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<ObjectLayoutBox, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<ObjectLayoutBox, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<ObjectLayoutBox, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<ObjectLayoutBox, Object>>();
		Map<String, BiConsumer<ObjectLayoutBox, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<ObjectLayoutBox, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ObjectLayoutBox::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ObjectLayoutBox, Long>)ObjectLayoutBox::setMvccVersion);
		attributeGetterFunctions.put("uuid", ObjectLayoutBox::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ObjectLayoutBox, String>)ObjectLayoutBox::setUuid);
		attributeGetterFunctions.put(
			"objectLayoutBoxId", ObjectLayoutBox::getObjectLayoutBoxId);
		attributeSetterBiConsumers.put(
			"objectLayoutBoxId",
			(BiConsumer<ObjectLayoutBox, Long>)
				ObjectLayoutBox::setObjectLayoutBoxId);
		attributeGetterFunctions.put(
			"companyId", ObjectLayoutBox::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ObjectLayoutBox, Long>)ObjectLayoutBox::setCompanyId);
		attributeGetterFunctions.put("userId", ObjectLayoutBox::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ObjectLayoutBox, Long>)ObjectLayoutBox::setUserId);
		attributeGetterFunctions.put("userName", ObjectLayoutBox::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ObjectLayoutBox, String>)ObjectLayoutBox::setUserName);
		attributeGetterFunctions.put(
			"createDate", ObjectLayoutBox::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ObjectLayoutBox, Date>)ObjectLayoutBox::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ObjectLayoutBox::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ObjectLayoutBox, Date>)
				ObjectLayoutBox::setModifiedDate);
		attributeGetterFunctions.put(
			"objectLayoutTabId", ObjectLayoutBox::getObjectLayoutTabId);
		attributeSetterBiConsumers.put(
			"objectLayoutTabId",
			(BiConsumer<ObjectLayoutBox, Long>)
				ObjectLayoutBox::setObjectLayoutTabId);
		attributeGetterFunctions.put(
			"collapsable", ObjectLayoutBox::getCollapsable);
		attributeSetterBiConsumers.put(
			"collapsable",
			(BiConsumer<ObjectLayoutBox, Boolean>)
				ObjectLayoutBox::setCollapsable);
		attributeGetterFunctions.put("name", ObjectLayoutBox::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<ObjectLayoutBox, String>)ObjectLayoutBox::setName);
		attributeGetterFunctions.put("priority", ObjectLayoutBox::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<ObjectLayoutBox, Integer>)ObjectLayoutBox::setPriority);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectLayoutBoxId() {
		return _objectLayoutBoxId;
	}

	@Override
	public void setObjectLayoutBoxId(long objectLayoutBoxId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectLayoutBoxId = objectLayoutBoxId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectLayoutTabId() {
		return _objectLayoutTabId;
	}

	@Override
	public void setObjectLayoutTabId(long objectLayoutTabId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectLayoutTabId = objectLayoutTabId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectLayoutTabId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectLayoutTabId"));
	}

	@Override
	public boolean getCollapsable() {
		return _collapsable;
	}

	@Override
	public boolean isCollapsable() {
		return _collapsable;
	}

	@Override
	public void setCollapsable(boolean collapsable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_collapsable = collapsable;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectLayoutBox.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectLayoutBox.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectLayoutBox.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectLayoutBox toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectLayoutBox>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectLayoutBoxImpl objectLayoutBoxImpl = new ObjectLayoutBoxImpl();

		objectLayoutBoxImpl.setMvccVersion(getMvccVersion());
		objectLayoutBoxImpl.setUuid(getUuid());
		objectLayoutBoxImpl.setObjectLayoutBoxId(getObjectLayoutBoxId());
		objectLayoutBoxImpl.setCompanyId(getCompanyId());
		objectLayoutBoxImpl.setUserId(getUserId());
		objectLayoutBoxImpl.setUserName(getUserName());
		objectLayoutBoxImpl.setCreateDate(getCreateDate());
		objectLayoutBoxImpl.setModifiedDate(getModifiedDate());
		objectLayoutBoxImpl.setObjectLayoutTabId(getObjectLayoutTabId());
		objectLayoutBoxImpl.setCollapsable(isCollapsable());
		objectLayoutBoxImpl.setName(getName());
		objectLayoutBoxImpl.setPriority(getPriority());

		objectLayoutBoxImpl.resetOriginalValues();

		return objectLayoutBoxImpl;
	}

	@Override
	public ObjectLayoutBox cloneWithOriginalValues() {
		ObjectLayoutBoxImpl objectLayoutBoxImpl = new ObjectLayoutBoxImpl();

		objectLayoutBoxImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectLayoutBoxImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectLayoutBoxImpl.setObjectLayoutBoxId(
			this.<Long>getColumnOriginalValue("objectLayoutBoxId"));
		objectLayoutBoxImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectLayoutBoxImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectLayoutBoxImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectLayoutBoxImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectLayoutBoxImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectLayoutBoxImpl.setObjectLayoutTabId(
			this.<Long>getColumnOriginalValue("objectLayoutTabId"));
		objectLayoutBoxImpl.setCollapsable(
			this.<Boolean>getColumnOriginalValue("collapsable"));
		objectLayoutBoxImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		objectLayoutBoxImpl.setPriority(
			this.<Integer>getColumnOriginalValue("priority"));

		return objectLayoutBoxImpl;
	}

	@Override
	public int compareTo(ObjectLayoutBox objectLayoutBox) {
		long primaryKey = objectLayoutBox.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectLayoutBox)) {
			return false;
		}

		ObjectLayoutBox objectLayoutBox = (ObjectLayoutBox)object;

		long primaryKey = objectLayoutBox.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectLayoutBox> toCacheModel() {
		ObjectLayoutBoxCacheModel objectLayoutBoxCacheModel =
			new ObjectLayoutBoxCacheModel();

		objectLayoutBoxCacheModel.mvccVersion = getMvccVersion();

		objectLayoutBoxCacheModel.uuid = getUuid();

		String uuid = objectLayoutBoxCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectLayoutBoxCacheModel.uuid = null;
		}

		objectLayoutBoxCacheModel.objectLayoutBoxId = getObjectLayoutBoxId();

		objectLayoutBoxCacheModel.companyId = getCompanyId();

		objectLayoutBoxCacheModel.userId = getUserId();

		objectLayoutBoxCacheModel.userName = getUserName();

		String userName = objectLayoutBoxCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectLayoutBoxCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectLayoutBoxCacheModel.createDate = createDate.getTime();
		}
		else {
			objectLayoutBoxCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectLayoutBoxCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectLayoutBoxCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectLayoutBoxCacheModel.objectLayoutTabId = getObjectLayoutTabId();

		objectLayoutBoxCacheModel.collapsable = isCollapsable();

		objectLayoutBoxCacheModel.name = getName();

		String name = objectLayoutBoxCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectLayoutBoxCacheModel.name = null;
		}

		objectLayoutBoxCacheModel.priority = getPriority();

		return objectLayoutBoxCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectLayoutBox, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectLayoutBox, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectLayoutBox, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectLayoutBox)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<ObjectLayoutBox, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<ObjectLayoutBox, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectLayoutBox, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((ObjectLayoutBox)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectLayoutBox>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectLayoutBox.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectLayoutBoxId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectLayoutTabId;
	private boolean _collapsable;
	private String _name;
	private String _nameCurrentLanguageId;
	private int _priority;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectLayoutBox, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectLayoutBox)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectLayoutBoxId", _objectLayoutBoxId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectLayoutTabId", _objectLayoutTabId);
		_columnOriginalValues.put("collapsable", _collapsable);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("priority", _priority);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectLayoutBoxId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectLayoutTabId", 256L);

		columnBitmasks.put("collapsable", 512L);

		columnBitmasks.put("name", 1024L);

		columnBitmasks.put("priority", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectLayoutBox _escapedModel;

}