/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.action.executor;

import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.constants.ObjectActionExecutorConstants;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.util.UnicodeProperties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marco Leo
 */
@Component(service = ObjectActionExecutor.class)
public class GroovyObjectActionExecutorImpl implements ObjectActionExecutor {

	@Override
	public void execute(
			long companyId, UnicodeProperties parametersUnicodeProperties,
			JSONObject payloadJSONObject, long userId)
		throws Exception {

		Map<String, Object> inputObjects = new HashMap<>();

		for (String key : payloadJSONObject.keySet()) {
			inputObjects.put(key, payloadJSONObject.get(key));
		}

		_execute(inputObjects, parametersUnicodeProperties.get("script"));
	}

	@Override
	public String getKey() {
		return ObjectActionExecutorConstants.KEY_GROOVY;
	}

	private void _execute(Map<String, Object> inputObjects, String script)
		throws Exception {

		Thread currentThread = Thread.currentThread();

		ClassLoader contextClassLoader = currentThread.getContextClassLoader();

		Class<?> clazz = getClass();

		ClassLoader classLoader = clazz.getClassLoader();

		try {
			currentThread.setContextClassLoader(classLoader);

			_scripting.eval(
				null, inputObjects, new HashSet<>(), "groovy", script);
		}
		finally {
			currentThread.setContextClassLoader(contextClassLoader);
		}
	}

	@Reference
	private Scripting _scripting;

}