/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.ObjectValidationRuleEngineException;
import com.liferay.object.exception.ObjectValidationRuleNameException;
import com.liferay.object.exception.ObjectValidationRuleScriptException;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.base.ObjectValidationRuleLocalServiceBaseImpl;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.object.validation.rule.ObjectValidationRuleEngineServicesTracker;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectValidationRule"}, service={AopService.class})
public class ObjectValidationRuleLocalServiceImpl
extends ObjectValidationRuleLocalServiceBaseImpl {
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectValidationRuleEngineServicesTracker _objectValidationRuleEngineServicesTracker;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule addObjectValidationRule(long userId, long objectDefinitionId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String script) throws PortalException {
        this._validateEngine(engine);
        this._validateName(nameMap);
        this._validateScript(script);
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectValidationRule.setCompanyId(user.getCompanyId());
        objectValidationRule.setUserId(user.getUserId());
        objectValidationRule.setUserName(user.getFullName());
        objectValidationRule.setObjectDefinitionId(objectDefinitionId);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setScript(script);
        return (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectValidationRule deleteObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        return this.deleteObjectValidationRule(objectValidationRule);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectValidationRule deleteObjectValidationRule(ObjectValidationRule objectValidationRule) {
        return (ObjectValidationRule)this.objectValidationRulePersistence.remove((BaseModel)objectValidationRule);
    }

    public void deleteObjectValidationRules(Long objectDefinitionId) throws PortalException {
        for (ObjectValidationRule objectValidationRule : this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId.longValue())) {
            this.objectValidationRuleLocalService.deleteObjectValidationRule(objectValidationRule);
        }
    }

    @Override
    public ObjectValidationRule getObjectValidationRule(long objectValidationRuleId) throws PortalException {
        return this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId) {
        return this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId, boolean active) {
        return this.objectValidationRulePersistence.findByODI_A(objectDefinitionId, active);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule updateObjectValidationRule(long objectValidationRuleId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String script) throws PortalException {
        this._validateEngine(engine);
        this._validateName(nameMap);
        this._validateScript(script);
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setScript(script);
        return (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
    }

    public void validate(long userId, long objectDefinitionId, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws PortalException {
        Map values = null;
        if (objectEntry != null) {
            values = this._objectEntryLocalService.getValues(objectEntry);
        }
        List objectValidationRules = this.objectValidationRuleLocalService.getObjectValidationRules(objectDefinitionId, true);
        for (ObjectValidationRule objectValidationRule : objectValidationRules) {
            ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineServicesTracker.getObjectValidationRuleEngine(objectValidationRule.getEngine());
            HashMapBuilder.HashMapWrapper hashMapWrapper = HashMapBuilder.putAll((Map)objectEntry.getModelAttributes());
            if (objectEntry != null && values != null) {
                hashMapWrapper.putAll(values);
            }
            if (originalObjectEntry != null) {
                Map modelAttributes = originalObjectEntry.getModelAttributes();
                for (Map.Entry entry : modelAttributes.entrySet()) {
                    hashMapWrapper.put((Object)("original." + (String)entry.getKey()), entry.getValue());
                }
            }
            if (userId > 0L) {
                User user = this._userLocalService.getUser(userId);
                hashMapWrapper.put((Object)"user.emailAddress", (Object)user.getEmailAddress()).put((Object)"user.firstName", (Object)user.getFirstName()).put((Object)"user.lastName", (Object)user.getLastName()).put((Object)"userId", (Object)userId);
            }
            if (objectValidationRuleEngine.evaluate((Map)hashMapWrapper.build(), objectValidationRule.getScript())) continue;
            throw new ObjectValidationRuleScriptException(objectValidationRule.getErrorLabel(LocaleUtil.getMostRelevantLocale()));
        }
    }

    private void _validateEngine(String engine) throws PortalException {
        if (Validator.isNull((String)engine)) {
            throw new ObjectValidationRuleEngineException("Engine is null");
        }
        ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineServicesTracker.getObjectValidationRuleEngine(engine);
        if (objectValidationRuleEngine == null) {
            throw new ObjectValidationRuleEngineException("Engine \"" + engine + "\" does not exist");
        }
    }

    private void _validateName(Map<Locale, String> nameMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (nameMap == null || Validator.isNull((String)nameMap.get(locale))) {
            throw new ObjectValidationRuleNameException("Name is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateScript(String script) throws PortalException {
        if (Validator.isNull((String)script)) {
            throw new ObjectValidationRuleScriptException("Script is null");
        }
    }
}

